/*
 * Decompiled with CFR 0.152.
 */
package MovingBall;

import app.RecipeList;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TabMenu {
    int background = 0xFFFFFF;
    int bgColor = 2439228;
    int bgFocusedColor = 0x800080;
    int foreColor = 0;
    int foreFocusedColor = 0xFFFFFF;
    int cornerRadius = 6;
    int padding = 2;
    int margin = 2;
    Font font = Font.getDefaultFont();
    int scrollStep = 20;
    int selectedTab = 0;
    int[] tabsWidth = null;
    int[] tabsLeft = null;
    public static int tabHeight = 0;
    String[] tabs = null;
    int menuWidth = 0;
    int viewportWidth = 0;
    int viewportX = 0;
    public static int yCord = 10;

    public TabMenu(String[] tabs, int width) {
        this.tabs = tabs;
        this.viewportWidth = width;
        this.initialize();
    }

    void initialize() {
        tabHeight = this.font.getHeight() + this.cornerRadius + 2 * this.padding;
        this.menuWidth = 0;
        this.tabsWidth = new int[this.tabs.length];
        this.tabsLeft = new int[this.tabs.length];
        for (int i = 0; i < this.tabsWidth.length; ++i) {
            this.tabsWidth[i] = RecipeList.screenWidth / 2 - 1;
            this.tabsLeft[i] = this.menuWidth;
            this.menuWidth += this.tabsWidth[i];
            if (i <= 0) continue;
            this.menuWidth += this.margin;
        }
    }

    public void goRight() {
        this.go(1);
    }

    public void goLeft() {
        this.go(-1);
    }

    private void go(int delta) {
        int newTab = Math.max(0, Math.min(this.tabs.length - 1, this.selectedTab + delta));
        boolean scroll = true;
        if (newTab != this.selectedTab && this.isTabVisible(newTab)) {
            this.selectedTab = newTab;
            scroll = delta > 0 && this.tabsLeft[this.selectedTab] + this.tabsWidth[this.selectedTab] > this.viewportX + this.viewportWidth || delta < 0 && this.tabsLeft[this.selectedTab] < this.viewportX;
        }
        if (scroll) {
            this.viewportX = Math.max(0, Math.min(this.menuWidth - this.viewportWidth, this.viewportX + delta * this.scrollStep));
        }
    }

    private boolean isTabVisible(int tabIndex) {
        return this.tabsLeft[tabIndex] < this.viewportX + this.viewportWidth && this.tabsLeft[tabIndex] + this.tabsWidth[tabIndex] >= this.viewportX;
    }

    public void paint(Graphics g) {
        int currentX = -this.viewportX;
        g.setClip(0, yCord, this.viewportWidth, tabHeight + yCord);
        g.setColor(this.background);
        g.fillRect(0, 0, this.viewportWidth, tabHeight);
        for (int i = 0; i < this.tabs.length; ++i) {
            g.setColor(i == this.selectedTab ? this.bgFocusedColor : this.bgColor);
            g.fillRoundRect(currentX, yCord, this.tabsWidth[i], tabHeight + this.cornerRadius, 2 * this.cornerRadius, 2 * this.cornerRadius);
            g.setColor(i == this.selectedTab ? this.foreFocusedColor : this.foreColor);
            g.drawString(this.tabs[i], currentX + this.cornerRadius + this.padding, this.cornerRadius + this.padding + yCord, 20);
            currentX += this.tabsWidth[i] + this.margin;
        }
    }

    public int getSelectedIndex(int x, int y) {
        int currentX = -this.viewportX;
        for (int i = 0; i < this.tabs.length; ++i) {
            if (x > currentX && x < currentX + this.tabsWidth[i] && y > yCord && y < tabHeight + yCord) {
                return i;
            }
            currentX += this.tabsWidth[i] + this.margin;
        }
        return -1;
    }

    public int getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(int selectedTa) {
        this.selectedTab = selectedTa;
    }
}

