window.frameworkModules = ['lib/PluginResult.js', 'lib/config.js', 'lib/controllerWebView.js', 'lib/event.js', 'lib/exception.js', 'lib/framework.js', 'lib/jnext.js', 'lib/overlayWebView.js', 'lib/server.js', 'lib/utils.js', 'lib/webkitEvent.js', 'lib/webview.js', 'lib/config/default.js', 'lib/config/user.js', 'lib/events/applicationEvents.js', 'lib/events/deviceEvents.js', 'lib/plugins/default.js', 'lib/plugins/event.js', 'lib/policy/folderAccess.js', 'lib/policy/webkitOriginAccess.js', 'lib/policy/whitelist.js', 'lib/webkitHandlers/networkResourceRequested.js', 'plugin/Accelerometer/index.js', 'plugin/Battery/index.js', 'plugin/Camera/index.js', 'plugin/Contacts/index.js', 'plugin/Contacts/ContactActivity.js', 'plugin/Contacts/ContactAddress.js', 'plugin/Contacts/contactConsts.js', 'plugin/Contacts/ContactError.js', 'plugin/Contacts/ContactField.js', 'plugin/Contacts/ContactFindOptions.js', 'plugin/Contacts/ContactName.js', 'plugin/Contacts/ContactNews.js', 'plugin/Contacts/ContactOrganization.js', 'plugin/Contacts/ContactPhoto.js', 'plugin/Contacts/contactUtils.js', 'plugin/Device/index.js', 'plugin/Logger/index.js', 'plugin/Media/index.js', 'plugin/NetworkStatus/index.js', 'plugin/Notification/index.js', 'plugin/SplashScreen/index.js'];
(function () { define('lib/PluginResult.js', function (require, exports, module) {
/*
 * Copyright 2013 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function PluginResult (args, env) {

    var CALLBACK_STATUS_NO_RESULT = 0,
        CALLBACK_STATUS_OK = 1,
        CALLBACK_STATUS_ERROR = 9,
        callbackId = JSON.parse(decodeURIComponent(args.callbackId)),
        send = function (data) {
            env.response.send(200, encodeURIComponent(JSON.stringify(data)));
        },
        callback = function (success, status, data, keepCallback) {
            var executeString = "cordova.callbackFromNative('" + callbackId  + "', " +
                !!success + ", " + status + ", [" + data + "], " + !!keepCallback + ");";
            env.webview.executeJavaScript(executeString);
        };

    Object.defineProperty(this, "callbackId", {enumerable: true, value: callbackId});

    this.noResult = function (keepCallback) {
        send({ code: CALLBACK_STATUS_NO_RESULT, keepCallback: !!keepCallback });
    };

    this.error = function (msg, keepCallback) {
        send({ code: CALLBACK_STATUS_ERROR, msg: msg, keepCallback: !!keepCallback });
    };

    this.ok = function (data, keepCallback) {
        send({ code: CALLBACK_STATUS_OK, data: data, keepCallback: !!keepCallback });
    };

    this.callbackOk = function (data, keepCallback) {
        callback(true, CALLBACK_STATUS_OK, JSON.stringify(data), keepCallback);
    };

    this.callbackError = function (msg, keepCallback) {
        callback(false, CALLBACK_STATUS_ERROR, JSON.stringify(msg), keepCallback);
    };
}

window.PluginResult = PluginResult;

});
define('lib/config.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var defaults = require('./config/default'),
    user = require('./config/user'),
    utils = require('./utils');

module.exports = utils.mixin(user,
                 utils.mixin(defaults, {}));

});
define('lib/controllerWebView.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var controllerWebView,
    overlayWebView = require("./overlayWebView"),
    controller,
    invocation,
    utils;

controllerWebView = {
    init: function (config) {
        controller = window.qnx.webplatform.getController();
        invocation = window.qnx.webplatform.getApplication().invocation;
        utils = require('./utils');
        controller.enableWebInspector = config.debugEnabled;
        controller.enableCrossSiteXHR = true;
        controller.visible = false;
        controller.active = false;
        controller.setGeometry(0, 0, screen.width, screen.height);
        controller.setFileSystemSandbox = false;

        /* Remote functions that are published to allow communication with
         * the overlay webview, they are called via the RPC bridge
         */
        controller.publishRemoteFunction('webview.setSensitivity', function (args) {
            var sensitivityType = args[0];
            overlayWebView.setSensitivity(sensitivityType);
        });

        controller.publishRemoteFunction('webview.notifyContextMenuCancelled', function () {
            overlayWebView.notifyContextMenuCancelled();
        });
    },

    setGeometry: function (x, y, width, height) {
        controller.setGeometry(x, y, width, height);
    },

    setApplicationOrientation: function (angle) {
        controller.setApplicationOrientation(angle);
    },

    notifyApplicationOrientationDone: function () {
        controller.notifyApplicationOrientationDone();
    },

    dispatchEvent: function (eventType, args) {
        controller.dispatchEvent(eventType, args);
    }
};

controllerWebView.__defineGetter__('id', function () {
    return controller.id;
});

controllerWebView.__defineSetter__('onChildWebViewCreated', function (input) {
    controller.onChildWebViewCreated = input;
});
module.exports = controllerWebView;

});
define('lib/event.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var _handlers = {},
    _webview = require("./webview");

module.exports = {
    trigger: function (actionEvent) {
        var args = Array.prototype.slice.call(arguments),
            executeString = "webworks.event.trigger('" + actionEvent + "', '" + escape(encodeURIComponent(JSON.stringify(args.slice(1)))) + "')";

        if (_handlers.hasOwnProperty(actionEvent)) {
            _handlers[actionEvent].forEach(function (webview) {
                webview.executeJavaScript(executeString);
            });
        } else {
            //Just dump it in the content webview for consistency
            _webview.executeJavascript(executeString);
        }
    },

    add: function (action, webview) {
        var triggerEvent;

        if (action) {
            //Use action.event for old extensions that may not have triggerEvent defined
            triggerEvent = action.triggerEvent || action.event;

            if (!action.once) {
                action.context.addEventListener(action.event, action.trigger || this.trigger);
            }

            //If there are no registered listeners for this event, create an array to hold them
            if (!_handlers.hasOwnProperty(triggerEvent)) {
                _handlers[triggerEvent] = [];
            }
            //If the webview is not in the list of webviews listening to this action then add it
            if (!_handlers[triggerEvent].some(function (handlerWebView) {
                    return handlerWebView.id === webview.id;
                })) {
                _handlers[triggerEvent].push(webview);
            }

        } else {
            throw "Action is null or undefined";
        }
    },

    remove: function (action, webview) {
        if (action) {
            action.context.removeEventListener(action.event, action.trigger || this.trigger);

            //Remove the webview from the _handlers
            if (_handlers.hasOwnProperty(action.event)) {

                _handlers[action.event] = _handlers[action.event].filter(function (sourceWebview) {
                    return sourceWebview.id !== webview.id;
                });

                //If the array is empty delete it
                if (_handlers[action.event].length === 0) {
                    delete _handlers[action.event];
                }
            }

        } else {
            throw "Action is null or undefined";
        }

    }
};

});
define('lib/exception.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

module.exports = {

    types: {
        Application: "Application",
        ArgumentLength: "ArgumentLength",
        ArgumentType: "ArgumentType",
        Argument: "Argument",
        NotificationType: "NotificationType",
        NotificationStateType: "NotificationStateType",
        DomObjectNotFound: "DomObjectNotFound",
        MethodNotImplemented: "MethodNotImplemented",
        InvalidState: "InvalidState",
        ApplicationState: "ApplicationState"
    },

    handle: function handle(exception, reThrow) {
        reThrow = reThrow || false;

        var eMsg = exception.message || "exception caught!",
        msg = eMsg + "\n\n" + (exception.stack || "*no stack provided*") + "\n\n";

        console.error(msg);

        if (reThrow) {
            throw exception;
        }
    },

    raise: function raise(exceptionType, message, customExceptionObject) {
        var obj = customExceptionObject || {
                type: "",
                message: "",

                toString: function () {
                    var result = this.name + ': "' + this.message + '"';

                    if (this.stack) {
                        result += "\n" + this.stack;
                    }
                    return result;
                }
            };

        message = message || "";

        obj.name = exceptionType;
        obj.type = exceptionType;
        // TODO: include the exception objects original message if exists
        obj.message = message;

        throw obj;
    }
};

});
define('lib/framework.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var utils = require('./utils'),
    controllerWebView = require('./controllerWebView'),
    webview = require('./webview'),
    overlayWebView = require('./overlayWebView'),
    config = require("./config"),
    appEvents = require("./events/applicationEvents"),
    actionMap = {
        pause: {
            event: "inactive",
            trigger: function () {
                webview.executeJavascript("cordova.fireDocumentEvent('pause')");
            }
        },
        resume: {
            event: "active",
            trigger: function () {
                webview.executeJavascript("cordova.fireDocumentEvent('resume')");
            }
        }
    };

function addEvents() {
    for (var action in actionMap) {
        if (actionMap.hasOwnProperty(action)) {
            appEvents.addEventListener(actionMap[action].event, actionMap[action].trigger);
        }
    }
}

function removeEvents() {
    for (var action in actionMap) {
        if (actionMap.hasOwnProperty(action)) {
            appEvents.removeEventListener(actionMap[action].event, actionMap[action].trigger);
        }
    }
}

function showWebInspectorInfo() {
    var port = window.qnx.webplatform.getApplication().webInspectorPort,
        messageObj = {};

    qnx.webplatform.device.getNetworkInterfaces(function (networkInfo) {
        var connectedInterface;

        utils.forEach(networkInfo, function (info) {
            if (info && !connectedInterface) {
                connectedInterface = info;
            }
        }, this);

        messageObj.title = "Web Inspector Enabled";
        if (connectedInterface) {
            messageObj.htmlmessage =  "\n ip4:    " + connectedInterface.ipv4Address + ":" + port + "<br/> ip6:    " + connectedInterface.ipv6Address + ":" + port;
        } else {
            messageObj.message = "";
        }
        messageObj.dialogType = 'JavaScriptAlert';
        overlayWebView.showDialog(messageObj);
    });
}

var _self = {
    start: function (url) {
        var callback,
            showUrlCallback;

        // Set up the controller WebView
        controllerWebView.init(config);

        webview.create(function () {
            if (config.enableFlash) {
                //Set webview plugin directory [required for flash]
                webview.setExtraPluginDirectory('/usr/lib/browser/plugins');

                //Enable plugins for the webview [required for flash]
                webview.setEnablePlugins(true);

                //Enable flash for the childWebViews
                controllerWebView.onChildWebViewCreated = function (child) {
                    //Set webview plugin directory [required for flash]
                    child.setExtraPluginDirectory('/usr/lib/browser/plugins');

                    //Enable plugins for the webview [required for flash]
                    child.pluginsEnabled = true;
                };
            }

            if (!config.enableWebSecurity) {
                webview.enableCrossSiteXHR = true;
            }

            if (!config.enablePopupBlocker) {
                qnx.webplatform.nativeCall('webview.setBlockPopups', webview.id, false);
            }
            // Workaround for executeJavascript doing nothing for the first time

            webview.executeJavascript("1 + 1");

            url = url || config.content;

            showUrlCallback = function () {
                overlayWebView.removeEventListener("DocumentLoadFinished", showUrlCallback);
                showUrlCallback = null;

                // Start page
                if (url) {
                    webview.setURL(url);
                }
            };

            overlayWebView.create(function () {
                overlayWebView.addEventListener("DocumentLoadFinished", showUrlCallback);

                overlayWebView.setURL("local:///chrome/ui.html");
                overlayWebView.renderContextMenuFor(webview);
                overlayWebView.handleDialogFor(webview);
                controllerWebView.dispatchEvent('ui.init', null);
                webview.setUIWebViewObj(overlayWebView.getWebViewObj());
                if (config.enableChildWebView) {
                    overlayWebView.bindAppWebViewToChildWebViewControls(webview);
                } else {
                    webview.onChildWindowOpen = function (data) {
                        var parsedData = JSON.parse(data);
                        utils.invokeInBrowser(parsedData.url);
                    };
                }
                if (config.enableFormControl) {
                    overlayWebView.getWebViewObj().formcontrol.subscribeTo(webview);
                }
            });
        },
        {
            debugEnabled : config.debugEnabled
        });

        addEvents();

        //if debugging is enabled, show the IP and port for webinspector
        if (config.debugEnabled) {
            callback = function () {
                showWebInspectorInfo();

                //Remove listener. Alert should only be shown once.
                webview.removeEventListener("DocumentLoadFinished", callback);
            };

            webview.addEventListener("DocumentLoadFinished", callback);
        }
    },
    stop: function () {
        removeEvents();
        webview.destroy();
    }
};

module.exports = _self;

});
define('lib/jnext.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global objJSExt */

function JNEXT_() {
    var self = this;
    var m_bFirstRequire = true;

    self.m_arEvents = {};

    self.onPageLoad = function() {
    };

    self.attachToDOM = function() {
        // Make sure JNEXT onPageLoad is called when page load
        //  completes without damaging existing onLoad handlers
        var prevOnLoad = window.onload;
        if( typeof window.onload != 'function') {
            window.onload = self.onPageLoad;
        } else {
            window.onload = function() {
                if(prevOnLoad) {
                    prevOnLoad();
                }

                self.onPageLoad();
            };
        }

        // Unobtrusively add the JNEXT plugin or ActiveX to the DOM
        var objBody = document.getElementsByTagName("body")[0];
        var objDiv = document.createElement('div');
        var strHTML;

        if(window.ActiveXObject) {
            strHTML = '<object id="objJSExt" width="0" height="0" classid="CLSID:C802F39D-BF85-427a-A334-77E501DB62E9" codebase="jnext.ocx"></object>';
            strHTML += '<script language="JavaScript" for="objJSExt" EVENT="Js2nEvent( strEvent )">JNEXT.processEvent(strEvent)</script>';
        } else {
            var strAddSrc = "";
            if(navigator.userAgent.indexOf("Safari") != -1 && navigator.userAgent.indexOf("Windows") != -1) {
                // This hack required on Safari for Windows
                strAddSrc = 'src="./jnext/safari.foo"';
            }
            strHTML = '<embed id="objJSExt" ' + strAddSrc + ' type="application/jnext-scriptable-plugin" width="0" height="0">';
        }

        objDiv.innerHTML = strHTML;
        objBody.appendChild(objDiv);
    };

    self.getosname = function() {
        return objJSExt.sendCmd("osname");
    };

    self.require = function(strLibrary) {
        // Load a required JNEXT plugin
        var strCmd;
        var strVal;
        var arParams;

        if(m_bFirstRequire) {
            strCmd = "userAgent " + navigator.userAgent;
            strVal = objJSExt.sendCmd(strCmd);
            arParams = strVal.split(" ");
            if(arParams[0] != "Ok") {
                alert("userAgent " + strVal);
                return false;
            }
            self.m_bFirstRequire = false;
        }
        strCmd = "Require " + strLibrary;
        strVal = objJSExt.sendCmd(strCmd);
        arParams = strVal.split(" ");
        if(arParams[0] != "Ok") {
            alert("Require " + strVal);
            return false;
        }

        return true;
    };

    self.createObject = function(strObjName) {
        // Create an instance of a native object
        var strCmd;
        var strVal;
        var arParams;
        strVal = objJSExt.sendCmd("CreateObject " + strObjName);
        arParams = strVal.split(" ");
        if(arParams[0] != "Ok") {
            alert("CreateObject: " + strVal);
            return "";
        }
        return arParams[1];
    };

    self.invoke = function(strObjId, strMethod, strParams) {
        // Invoke a method of a given instance of a native object
        var strCmd = "InvokeMethod " + strObjId + " " + strMethod;

        if( typeof (strParams) != "undefined") {
            strCmd += " " + strParams;
        }

        return objJSExt.sendCmd(strCmd);
    };

    self.registerEvents = function(objNotify) {
        var strId = objNotify.getId();
        self.m_arEvents[strId] = objNotify;
    };

    self.unregisterEvents = function(objNotify) {
        var strId = objNotify.getId();
        delete self.m_arEvents[strId];
    };

    self.processEvent = function(strNativeEvt) {
        // Process an event received from native code. The event
        // containes the target JavaScript object id and the
        // relevant parameters.

        var arParams = strNativeEvt.split(" ");
        var strObjId = arParams[0];
        var strEvent = strNativeEvt.substring(strObjId.length + 1);

        var objNotify = self.m_arEvents[strObjId];
        if( typeof (objNotify) == 'undefined') {
            alert("Warning: No object with Id " + strId + " found for event " + strEvent);
            return;
        }

        // This will now be handled by the appropriate JavaScript
        // JNEXT extension object
        objNotify.onEvent(strEvent);
    };

    self.ajaxGet = function(strUrl, id) {
        var req = false;
        if(window.ActiveXObject) {
            try {
                req = new ActiveXObject("Msxml2.XMLHTTP");
            } catch (e) {
                try {
                    req = new ActiveXObject("Microsoft.XMLHTTP");
                } catch (ex) {
                }
            }
        } else if(window.XMLHttpRequest) {
            req = new XMLHttpRequest();
        } else {
            return false;
        }

        req.onreadystatechange = function() {
            if(req.readyState == 4 && (req.status == 200 || window.location.href.indexOf("http") == -1)) {
                self.onAjaxRecv(req.responseText);
            }
        };

        req.open('GET', strUrl, true);
        req.send(null);
    };

    self.onAjaxRecv = function(strContent) {
        alert(strContent);
    };

    self.attachToDOM();
}

window.JNEXT = new JNEXT_();
module.exports = JNEXT;

});
define('lib/overlayWebView.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var CHROME_HEIGHT = 0,
    webview,
    _webviewObj;

webview =
    {

    create: function (ready, configSettings) {
        _webviewObj = window.qnx.webplatform.createUIWebView(function () {

            _webviewObj.visible = true;
            _webviewObj.active = true;
            _webviewObj.zOrder = 2;
            _webviewObj.enableCrossSiteXHR = true;
            _webviewObj.setGeometry(0, 0, screen.width, screen.height);
            _webviewObj.addEventListener("DocumentLoadFinished", function () {
                _webviewObj.default.setDefaultFont();
                _webviewObj.visible = true;
            });

            _webviewObj.allowRpc = true;
            _webviewObj.backgroundColor = 0x00FFFFFF;
            _webviewObj.sensitivity = "SensitivityTest";
            _webviewObj.devicePixelRatio = 1;
            _webviewObj.allowQnxObject = true;

            if (ready && typeof ready === 'function') {
                ready();
            }

            window.qnx.webplatform.getController().dispatchEvent("overlayWebView.initialized", [_webviewObj]);

        });
    },

    destroy: function () {
        _webviewObj.destroy();
    },

    setURL: function (url) {
        _webviewObj.url = url;
    },

    setGeometry: function (x, y, width, height) {
        _webviewObj.setGeometry(x, y, width, height);
    },

    setSensitivity : function (sensitivity) {
        _webviewObj.sensitivity = sensitivity;
    },

    setApplicationOrientation: function (angle) {
        _webviewObj.setApplicationOrientation(angle);
    },

    notifyApplicationOrientationDone: function () {
        _webviewObj.notifyApplicationOrientationDone();
    },

    executeJavascript: function (js) {
        _webviewObj.executeJavaScript(js);
    },

    windowGroup: function () {
        return _webviewObj.windowGroup;
    },

    notifyContextMenuCancelled: function () {
        _webviewObj.notifyContextMenuCancelled();
    },

    bindAppWebViewToChildWebViewControls: function (appWebView) {
        if (_webviewObj && _webviewObj.childwebviewcontrols) {
            _webviewObj.childwebviewcontrols.subscribeTo(appWebView);
        }
    },

    renderContextMenuFor: function (targetWebView) {
        return _webviewObj.contextMenu.subscribeTo(targetWebView);
    },

    handleDialogFor: function (targetWebView) {
        return _webviewObj.dialog.subscribeTo(targetWebView);
    },

    showDialog: function (description, callback) {
        return _webviewObj.dialog.show(description, callback);
    },

    getWebViewObj: function (webview) {
        return _webviewObj;
    },

    addEventListener: function (eventName, callback) {
        _webviewObj.addEventListener(eventName, callback);
    },

    removeEventListener: function (eventName, callback) {
        _webviewObj.removeEventListener(eventName, callback);
    },

    showToast : function (message, options) {
        return _webviewObj.toast.show(message, options);
    },

    showInvocationList: function (request, title, success, error) {
        _webviewObj.invocationlist.show(request, title, success, error);
    }
};

webview.__defineGetter__('id', function () {
    if (_webviewObj) {
        return _webviewObj.id;
    }
});

webview.__defineGetter__('zOrder', function () {
    return _webviewObj.zOrder;
});

webview.__defineGetter__('contextMenu', function () {
    if (_webviewObj) {
        return _webviewObj.contextMenu;
    }
});

module.exports = webview;

});
define('lib/server.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var DEFAULT_SERVICE = "default",
    DEFAULT_ACTION = "exec";

function rebuildRequest(req) {
    var originalURL = req.params.service + "/" +
            req.params.action +
            (req.params.ext ? "/" + req.params.ext  : "") +
            (req.params.method ? "/" + req.params.method : "") +
            (req.params.args ? "?" + req.params.args : ""),
        tokens = originalURL.split('/'),
        //Handle the case where the method is multi-level
        finalToken = (tokens[1] && tokens.length > 2) ? tokens.slice(1).join('/') : tokens[1],
        args = null;

    // set args
    if (finalToken && finalToken.indexOf("?") >= 0) {
        // Re-split args
        args = finalToken.split("?")[1];
    }

    return {
        params : {
            service : DEFAULT_SERVICE,
            action : DEFAULT_ACTION,
            ext : tokens[0],
            method : (finalToken && finalToken.indexOf("?") >= 0) ? finalToken.split("?")[0] : finalToken,
            args : args
        },
        body : req.body,
        origin : req.origin
    };
}

function parseArgs(req) {
    var args = null,
        params;
    // set args
    if (req.params.args && typeof req.params.args === "string") {
        // GET querystring to json
        params = req.params.args.split("&");
        if (params) {
            args = {};
            params.forEach(function (param) {
                var parts = param.split("=");
                args[parts[0]] = parts[1];
            });
        }
    } else {
        // POST body to json
        if (req.body) {
            args = JSON.parse(req.body);
        }
    }
    req.params.args = args;
}

module.exports = {
    handle: function (req, res, sourceWebview, config) {
        try {
            var pluginName = "lib/plugins/" + req.params.service,
                plugin;

            if (frameworkModules.indexOf(pluginName + ".js") === -1) {
                pluginName = "lib/plugins/" + DEFAULT_SERVICE;
                req = rebuildRequest(req);
            }

            parseArgs(req);

            //Updating because some versions of node only work with relative paths
            pluginName = pluginName.replace('lib', '.');

            plugin = require("./utils").loadModule(pluginName);

            plugin[req.params.action](req,
            function (result) {
                res.send(200, encodeURIComponent(JSON.stringify({
                    code: 42,
                    data: result
                })));
            },
            function (code, error, httpCode) {
                if (!httpCode) {
                    httpCode = 200;
                }

                res.send(httpCode, encodeURIComponent(JSON.stringify({
                    code: Math.abs(code) * -1 || -1,
                    data: null,
                    msg: error
                })));
            },
            req.params.args,
            {
                "request": req,
                "response": res,
                "webview": sourceWebview,
                "config": config
            });
        } catch (e) {
            console.error(e);
            res.send(404, "can't find the stuff");
        }
    }
};

});
define('lib/utils.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var self,
    exception = require('./exception');

function S4() {
    return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
}

self = module.exports = {
    validateNumberOfArguments: function (lowerBound, upperBound, numberOfArguments, customExceptionType, customExceptionMessage, customExceptionObject) {

        customExceptionMessage = customExceptionMessage || "";

        if (arguments.length < 3 || arguments.length > 6) {
            exception.raise(exception.types.Argument, "Wrong number of arguments when calling: validateNumberOfArguments()");
        }

        if (isNaN(lowerBound) && isNaN(upperBound) && isNaN(numberOfArguments)) {
            exception.raise(exception.types.ArgumentType, "(validateNumberOfArguments) Arguments are not numbers");
        }

        lowerBound = parseInt(lowerBound, 10);
        upperBound = parseInt(upperBound, 10);
        numberOfArguments = parseInt(numberOfArguments, 10);

        if (numberOfArguments < lowerBound || numberOfArguments > upperBound) {
            exception.raise((customExceptionType || exception.types.ArgumentLength), (customExceptionMessage + "\n\nWrong number of arguments"), customExceptionObject);
        }

    },

    validateArgumentType: function (arg, argType, customExceptionType, customExceptionMessage, customExceptionObject) {
        var invalidArg = false,
            msg;

        switch (argType) {
        case "array":
            if (!arg instanceof Array) {
                invalidArg = true;
            }
            break;
        case "date":
            if (!arg instanceof Date) {
                invalidArg = true;
            }
            break;
        case "integer":
            if (typeof arg === "number") {
                if (arg !== Math.floor(arg)) {
                    invalidArg = true;
                }
            }
            else {
                invalidArg = true;
            }
            break;
        default:
            if (typeof arg !== argType) {
                invalidArg = true;
            }
            break;
        }

        if (invalidArg) {
            msg = customExceptionMessage +  ("\n\nInvalid Argument type. argument: " + arg + " ==> was expected to be of type: " + argType);
            exception.raise((customExceptionType || exception.types.ArgumentType), msg, customExceptionObject);
        }
    },

    validateMultipleArgumentTypes: function (argArray, argTypeArray, customExceptionType, customExceptionMessage, customExceptionObject) {
        for (var i = 0; i < argArray.length; i++) {
            this.validateArgumentType(argArray[i], argTypeArray[i], customExceptionType, customExceptionMessage, customExceptionObject);
        }
    },

    arrayContains: function (array, obj) {
        var i = array.length;
        while (i--) {
            if (array[i] === obj) {
                return true;
            }
        }
        return false;
    },

    some: function (obj, predicate, scope) {
        if (obj instanceof Array) {
            return obj.some(predicate, scope);
        }
        else {
            var values = self.map(obj, predicate, scope);

            return self.reduce(values, function (some, value) {
                return value ? value : some;
            }, false);
        }
    },

    count: function (obj) {
        return self.sum(obj, function (total) {
            return 1;
        });
    },

    sum: function (obj, selector, scope) {
        var values = self.map(obj, selector, scope);
        return self.reduce(values, function (total, value) {
            return total + value;
        });
    },

    max: function (obj, selector, scope) {
        var values = self.map(obj, selector, scope);
        return self.reduce(values, function (max, value) {
            return max < value ? value : max;
        }, Number.MIN_VALUE);
    },

    min: function (obj, selector, scope) {
        var values = self.map(obj, selector, scope);
        return self.reduce(values, function (min, value) {
            return min > value ? value : min;
        }, Number.MAX_VALUE);
    },

    forEach: function (obj, action, scope) {
        if (obj instanceof Array) {
            return obj.forEach(action, scope);
        }
        else {
            self.map(obj, action, scope);
        }
    },

    filter: function (obj, predicate, scope) {
        if (obj instanceof Array) {
            return obj.filter(predicate, scope);
        }
        else {
            var result = [];
            self.forEach(obj, function (value, index) {
                if (predicate.apply(scope, [value, index])) {
                    result.push(value);
                }

            }, scope);

            return result;
        }
    },

    reduce: function (obj, func, init, scope) {
        var i,
            initial = init === undefined ? 0 : init,
            result = initial;


        if (obj instanceof Array) {
            return obj.reduce(func, initial);
        }
        else if (obj instanceof NamedNodeMap) {
            for (i = 0; i < obj.length; i++) {
                result = func.apply(scope, [result, obj[i], i]);
            }
        }
        else {
            for (i in obj) {
                if (obj.hasOwnProperty(i)) {
                    result = func.apply(scope, [result, obj[i], i]);
                }
            }
        }

        return result;

    },

    map: function (obj, func, scope) {
        var i,
            returnVal = null,
            result = [];

        if (obj instanceof Array) {
            return obj.map(func, scope);
        }
        else if (obj instanceof NamedNodeMap) {
            for (i = 0; i < obj.length; i++) {
                returnVal = func.apply(scope, [obj[i], i]);
                result.push(returnVal);
            }
        }
        else {
            for (i in obj) {
                if (obj.hasOwnProperty(i)) {
                    returnVal = func.apply(scope, [obj[i], i]);
                    result.push(returnVal);
                }
            }
        }

        return result;
    },

    series: function (tasks, callback) {

        var execute = function () {
            var args = [],
                task;

            if (tasks.length) {
                task = tasks.shift();
                args = args.concat(task.args).concat(execute);
                task.func.apply(this, args);
            }
            else {
                callback.func.apply(this, callback.args);
            }
        };

        execute();
    },

    regexSanitize: function (regexString) {
        return regexString.replace("^", "\\^")
                    .replace("$", "\\$")
                    .replace("(", "\\(")
                    .replace(")", "\\)")
                    .replace("<", "\\<")
                    .replace("[", "\\[")
                    .replace("{", "\\{")
                    .replace(/\\/, "\\\\")
                    .replace("|", "\\|")
                    .replace(">", "\\>")
                    .replace(".", "\\.")
                    .replace("*", "\\*")
                    .replace("+", "\\+")
                    .replace("?", "\\?");
    },

    find: function (comparison, collection, startInx, endInx, callback) {
        var results = [],
            compare = function (s, pattern) {

                if (typeof(s) !== "string" || pattern === null) {
                    return s === pattern;
                }

                var regex = pattern.replace(/\./g, "\\.")
                                   .replace(/\^/g, "\\^")
                                   .replace(/\*/g, ".*")
                                   .replace(/\\\.\*/g, "\\*");

                regex = "^".concat(regex, "$");

                return !!s.match(new RegExp(regex, "i"));
            };

        self.forEach(collection, function (c) {
            var match,
                fail = false;

            self.forEach(comparison, function (value, key) {
                if (!fail && value !== undefined) {

                    if (compare(c[key], value)) {
                        match = c;
                    }
                    else {
                        fail = true;
                        match = null;
                    }
                }
            });

            if (match) {
                results.push(match);
            }
        });

        if (callback) {
            if (startInx === undefined) {
                startInx = 0;
            }
            if (endInx === undefined) {
                endInx = results.length;
            }
            if (startInx === endInx) {
                endInx = startInx + 1;
            }

            callback.apply(null, [results.slice(startInx, endInx)]);
        }
    },

    mixin: function (mixin, to) {
        Object.getOwnPropertyNames(mixin).forEach(function (prop) {
            if (Object.hasOwnProperty.call(mixin, prop)) {
                Object.defineProperty(to, prop, Object.getOwnPropertyDescriptor(mixin, prop));
            }
        });
        return to;
    },

    copy: function (obj) {
        var i,
            newObj = (obj === null ? false : global.toString.call(obj) === "[object Array]") ? [] : {};

        if (typeof obj === 'number' ||
            typeof obj === 'string' ||
            typeof obj === 'boolean' ||
            obj === null ||
            obj === undefined) {
            return obj;
        }

        if (obj instanceof Date) {
            return new Date(obj);
        }

        if (obj instanceof RegExp) {
            return new RegExp(obj);
        }

        for (i in obj) {
            if (obj.hasOwnProperty(i)) {
                if (obj[i] && typeof obj[i] === "object") {
                    if (obj[i] instanceof Date) {
                        newObj[i] = obj[i];
                    }
                    else {
                        newObj[i] = self.copy(obj[i]);
                    }
                }
                else {
                    newObj[i] = obj[i];
                }
            }
        }

        return newObj;
    },

    startsWith : function (str, substr) {
        return str.indexOf(substr) === 0;
    },

    endsWith : function (str, substr) {
        return str.indexOf(substr, str.length - substr.length) !== -1;
    },

    parseUri : function (str) {
        var i, uri = {},
            key = [ "source", "scheme", "authority", "userInfo", "user", "password", "host", "port", "relative", "path", "directory", "file", "query", "anchor" ],
            matcher = /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/.exec(str);

        for (i = key.length - 1; i >= 0; i--) {
            uri[key[i]] = matcher[i] || "";
        }

        return uri;
    },

    // uri - output from parseUri
    isAbsoluteURI : function (uri) {
        if (uri && uri.source) {
            return uri.relative !== uri.source;
        }

        return false;
    },

    fileNameToImageMIME : function (fileName) {

        var extensionsToMIME = {},
            ext;

        extensionsToMIME.png = 'image/png';
        extensionsToMIME.jpg = 'image/jpeg';
        extensionsToMIME.jpe = 'image/jpeg';
        extensionsToMIME.jpeg = 'image/jpeg';
        extensionsToMIME.gif = 'image/gif';
        extensionsToMIME.bmp = 'image/bmp';
        extensionsToMIME.bm = 'image/bmp';
        extensionsToMIME.svg = 'image/svg+xml';
        extensionsToMIME.tif = 'image/tiff';
        extensionsToMIME.tiff = 'image/tiff';

        ext = fileName.split('.').pop();
        return extensionsToMIME[ext];
    },

    isLocalURI : function (uri) {
        return uri && uri.scheme && "local:///".indexOf(uri.scheme.toLowerCase()) !== -1;
    },

    isFileURI : function (uri) {
        return uri && uri.scheme && "file://".indexOf(uri.scheme.toLowerCase()) !== -1;
    },

    isHttpURI : function (uri) {
        return uri && uri.scheme && "http://".indexOf(uri.scheme.toLowerCase()) !== -1;
    },

    isHttpsURI : function (uri) {
        return uri && uri.scheme && "https://".indexOf(uri.scheme.toLowerCase()) !== -1;
    },

    // Checks if the specified uri starts with 'data:'
    isDataURI : function (uri) {
        return uri && uri.scheme && "data:".indexOf(uri.scheme.toLowerCase()) !== -1;
    },

    performExec : function (featureId, property, args) {
        var result;

        window.webworks.exec(function (data, response) {
            result = data;
        }, function (data, response) {
            throw data;
        }, featureId, property, args, true);

        return result;
    },

    inNode : function () {
        return !!require.resolve;
    },

    requireWebview : function () {
        return require("./webview");
    },
    convertDataToBinary : function (data, dataEncoding) {
        var rawData,
            uint8Array,
            i;

        if (data) {
            if (dataEncoding.toLowerCase() === "base64") {
                rawData = window.atob(data);
            }
            else {
                rawData = data;
            }

            uint8Array = new Uint8Array(new ArrayBuffer(rawData.length));

            for (i = 0; i < uint8Array.length; i++) {
                uint8Array[i] = rawData.charCodeAt(i);
            }

            return uint8Array.buffer;
        }
    },
    getBlobWithArrayBufferAsData : function (data, dataEncoding) {
        var rawData,
            blobBuilderObj = new window.WebKitBlobBuilder();
        rawData = this.convertDataToBinary(data, dataEncoding);
        blobBuilderObj.append(rawData);

        return blobBuilderObj.getBlob("arraybuffer");
    },
    loadModule: function (module) {
        return require(module);
    },
    loadExtensionModule: function (plugin, path) {
        if (plugin && path) {
            return require("../plugin/" + plugin + "/" + path);
        } else {
            return null;
        }
    },
    hasPermission: function (config, permission) {
        if (config && config.permissions && config.permissions.length) {
            return config.permissions.indexOf(permission) >= 0;
        }

        return false;
    },
    guid: function () {
        return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4());
    },
    getURIPrefix: function () {
        return "http://localhost:8472/";
    },
    translatePath: function (path) {
        if (path.indexOf("local:///") === 0) {
            var sourceDir = window.qnx.webplatform.getApplication().getEnv("HOME"); //leading slashes need to be removed
            path = "file:///" + sourceDir.replace(/^\/*/, '') + "/../app/native/" + path.replace(/local:\/\/\//, '');
        }
        return path;
    },
    invokeInBrowser: function (url) {
        var request = {
            uri: url,
            target: "sys.browser"
        };
        window.qnx.webplatform.getApplication().invocation.invoke(request);
    },
    isPersonal: function () {
        return window.qnx.webplatform.getApplication().getEnv("PERIMETER") === "personal";
    },
    deepclone: function (obj) {
        var newObj = obj instanceof Array ? [] : {},
            key;

        if (typeof obj === 'number' ||
                typeof obj === 'string' ||
                typeof obj === 'boolean' ||
                obj === null ||
                obj === undefined) {
            return obj;
        }

        if (obj instanceof Date) {
            return new Date(obj);
        }

        if (obj instanceof RegExp) {
            return new RegExp(obj);
        }

        for (key in obj) {
            if (obj.hasOwnProperty(key)) {
                if (obj[key] && typeof obj[key] === "object") {
                    newObj[key] = self.deepclone(obj[key]);
                } else {
                    newObj[key] = obj[key];
                }
            }
        }

        return newObj;
    }
};

});
define('lib/webkitEvent.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var utils = require('./utils'),
    exception = require('./exception'),
    _listeners = {};

function _on(eventType, listener, scope, once) {
    if (!eventType) {
        throw "eventType must be truthy";
    }
    _listeners[eventType] = _listeners[eventType] || [];
    _listeners[eventType].push({
        func: listener,
        scope: scope,
        once: !!once
    });
}

function _trigger(listener, args, sync) {
    try {
        if (sync) {
            listener.func.apply(listener.scope, args);
        }
        else {
            setTimeout(function () {
                listener.func.apply(listener.scope, args);
            }, 1);
        }
    }
    catch (e) {
        exception.handle(e);
    }
}

module.exports = {
    on: function (eventType, listener, scope) {
        _on(eventType, listener, scope, false);
    },

    once: function (eventType, listener, scope) {
        _on(eventType, listener, scope, true);
    },

    trigger: function (eventType, args, sync) {
        args = args || [];
        sync = sync || false;

        var listeners = _listeners[eventType];

        if (listeners) {
            listeners.forEach(function (listener) {
                _trigger(listener, args, sync);
            });

            _listeners[eventType] = listeners.filter(function (listener) {
                return !listener.once;
            });
        }
    },

    eventHasSubscriber: function (eventType) {
        return !!_listeners[eventType];
    },

    getEventSubscribers: function (eventType) {
        return utils.copy(_listeners[eventType]) || [];
    },

    clear: function (eventType) {
        if (eventType) {
            delete _listeners[eventType];
        }
    }
};

});
define('lib/webview.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var networkResourceRequested = require('./webkitHandlers/networkResourceRequested'),
    utils = require('./utils'),
    config = require('./config'),
    webkitOriginAccess = require("./policy/webkitOriginAccess"),
    CHROME_HEIGHT = 0,
    OUT_OF_PROCESS = 1,
    webview,
    _webviewObj;

webview =
    {
    create: function (ready) {
        _webviewObj = window.qnx.webplatform.createWebView({processId: OUT_OF_PROCESS, defaultSendEventHandlers: ['onChooseFile', 'onOpenWindow'], defaultWebEventHandlers: ['InvokeRequestEvent']}, function () {
            //Create webkit event handlers
            var requestObj =  networkResourceRequested.createHandler(_webviewObj);

            //Bind networkResourceRequested event so that everything works
            _webviewObj.onNetworkResourceRequested = requestObj.networkResourceRequestedHandler;

            webkitOriginAccess.addWebView(_webviewObj);

            _webviewObj.visible = true;
            _webviewObj.active = true;
            _webviewObj.zOrder = 0;
            _webviewObj.setGeometry(0, CHROME_HEIGHT, screen.width, screen.height - CHROME_HEIGHT);

            if (typeof config.backgroundColor !== 'undefined') {
                _webviewObj.backgroundColor = config.backgroundColor;
            }

            if (typeof config.customHeaders !== 'undefined') {
                _webviewObj.extraHttpHeaders = config.customHeaders;
            }

            if (typeof config.userAgent !== 'undefined') {
                _webviewObj.userAgent = config.userAgent;
            }

            _webviewObj.autoDeferNetworkingAndJavaScript = config.autoDeferNetworkingAndJavaScript;

            /* Catch and trigger our custom HTML dialog */
            _webviewObj.allowWebEvent("DialogRequested");

            _webviewObj.addEventListener("DocumentLoadFinished", function () {
                // show app window if auto hide splash screen is true, OR splash screen is not specified
                // if auto hide is set to false explicitly but no splash screen is specified, should still show app window
                // otherwise the app cannot be launched
                if (config.autoHideSplashScreen || !config["rim:splash"]) {
                    window.qnx.webplatform.getApplication().windowVisible = true;
                }
            });


            if (ready && typeof ready === 'function') {
                ready();
            }

            window.qnx.webplatform.getController().dispatchEvent("webview.initialized", [_webviewObj]);

            // If content is not loaded, too bad open the visibility up.
            setTimeout(function () {
                if (config.autoHideSplashScreen || !config["rim:splash"]) {
                    window.qnx.webplatform.getApplication().windowVisible = true;
                }
            }, 2500);
        });

    },

    destroy: function () {
        _webviewObj.destroy();
    },

    setURL: function (url) {
        _webviewObj.url = url;
    },

    reload: function () {
        _webviewObj.reload();
    },

    executeJavascript: function (js) {
        _webviewObj.executeJavaScript(js);
    },

    addEventListener: function (eventName, callback) {
        _webviewObj.addEventListener(eventName, callback);
    },

    removeEventListener: function (eventName, callback) {
        _webviewObj.removeEventListener(eventName, callback);
    },

    windowGroup: function () {
        return _webviewObj.windowGroup;
    },

    getGeometry: function () {
        return this.geometry;
    },

    setGeometry: function (x, y, width, height) {
        this.geometry = {x: x, y: y, w: width, h: height};
        _webviewObj.setGeometry(x, y, width, height);
    },

    setApplicationOrientation: function (angle) {
        _webviewObj.setApplicationOrientation(angle);
    },

    setExtraPluginDirectory: function (directory) {
        _webviewObj.setExtraPluginDirectory(directory);
    },

    setEnablePlugins: function (enablePlugins) {
        _webviewObj.pluginsEnabled = enablePlugins;
    },

    getEnablePlugins: function () {
        return _webviewObj.pluginsEnabled;
    },

    notifyApplicationOrientationDone: function () {
        _webviewObj.notifyApplicationOrientationDone();
    },

    setSandbox: function (sandbox) {
        _webviewObj.setFileSystemSandbox = sandbox;
    },

    getSandbox: function () {
        return _webviewObj.setFileSystemSandbox;
    },

    downloadURL: function (url) {
        _webviewObj.downloadURL(url);
    },

    handleContextMenuResponse: function (action) {
        _webviewObj.handleContextMenuResponse(action);
    },

    allowGeolocation : function (url) {
        _webviewObj.allowGeolocation(url);
    },

    disallowGeolocation : function (url) {
        _webviewObj.disallowGeolocation(url);

    },

    addKnownSSLCertificate: function (url, certificateInfo) {
        _webviewObj.addKnownSSLCertificate(url, certificateInfo);
    },

    continueSSLHandshaking: function (streamId, SSLAction) {
        _webviewObj.continueSSLHandshaking(streamId, SSLAction);
    },

    getSensitivity: function () {
        return _webviewObj.getSensitivity();
    },

    setSensitivity: function (sensitivity) {
        return _webviewObj.setSensitivity(sensitivity);
    },

    getBackgroundColor: function () {
        return _webviewObj.getBackgroundColor();
    },

    setBackgroundColor: function (backgroundColor) {
        return _webviewObj.setBackgroundColor(backgroundColor);
    },

    getWebViewObj: function (webview) {
        return _webviewObj;
    },

    setUIWebViewObj: function (webviewObj) {
        _webviewObj.uiWebView = webviewObj;
    },

    allowUserMedia: function (evtId, cameraName) {
        _webviewObj.allowUserMedia(evtId, cameraName);
    },

    disallowUserMedia: function (evtId) {
        _webviewObj.disallowUserMedia(evtId);
    }
};

webview.__defineGetter__('id', function () {
    if (_webviewObj) {
        return _webviewObj.id;
    }
});

webview.__defineGetter__('enableCrossSiteXHR', function () {
    return _webviewObj.enableCrossSiteXHR;
});

webview.__defineSetter__('enableCrossSiteXHR', function (shouldEnable) {
    _webviewObj.enableCrossSiteXHR = !!shouldEnable;
});

webview.__defineGetter__('processId', function () {
    return _webviewObj.processId;
});

webview.__defineSetter__('onOpenWindow', function (input) {
    _webviewObj.onOpenWindow = input;
});

webview.__defineSetter__('onCloseWindow', function (input) {
    _webviewObj.onCloseWindow = input;
});

webview.__defineSetter__('onDestroyWindow', function (input) {
    _webviewObj.onDestroyWindow = input;
});

webview.__defineSetter__('onDialogRequested', function (input) {
    _webviewObj.onDialogRequested = input;
});

webview.__defineSetter__('onGeolocationPermissionRequest', function (input) {
    _webviewObj.onGeolocationPermissionRequest = input;
});

webview.__defineSetter__('onSSLHandshakingFailed', function (input) {
    _webviewObj.onSSLHandshakingFailed = input;
});

webview.__defineSetter__('onPropertyCurrentContextEvent', function (input) {
    _webviewObj.onPropertyCurrentContextEvent = input;
});

webview.__defineSetter__('onContextMenuRequestEvent', function (input) {
    _webviewObj.onContextMenuRequestEvent = input;
});

webview.__defineSetter__('onContextMenuCancelEvent', function (input) {
    _webviewObj.onContextMenuCancelEvent = input;
});

webview.__defineSetter__('onUserMediaRequest', function (input) {
    _webviewObj.onUserMediaRequest = input;
});

webview.__defineSetter__('onChildWindowOpen', function (input) {
    _webviewObj.onChildWindowOpen = input;
});

module.exports = webview;

});
define('lib/config/default.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

module.exports = {
    configXML: "config.xml",
    configXMLDoc: null,

    backButtonBehavior: "back",
    customHeaders: {},
    version: "1.0.0",

    author: "",
    authorURL: "",
    authorEmail: "",
    copyright: "",
    content: "index.html",
    contentCharset: "",
    contentType: "",
    description: "",
    icon: "AIRApp_72.png",
    iconHover: "",
    id: "",
    license: "",
    licenseURL: "",
    name: "WebWorksAppTemplate",

    navigationMode: "pointer",

    preferredTransports: null,
    transportTimeout: 300000,

    hasMultiAccess: false,
    widgetExtensions: null,
    featureTable: null,
    accessList: null,
    permissions: null,

    loadingScreenColor: "#FFFFFF",
    backgroundImage: "",
    foregroundImage: "",
    onFirstLaunch: false,
    onLocalPageLoad: false,
    onRemotePageLoad: false,
    transitionType: -1,
    transitionDuration: 250,
    transitionDirection: 128,

    disableAllCache: false,
    aggressiveCacheAge: 2592000,
    maxCacheSizeTotal: 1024,
    maxCacheSizeItem: 128,
    maxStandardCacheAge: 2592000,

    runOnStartUp: false,
    allowInvokeParams: false,
    backgroundSource: "",
    foregroundSource: "index.html",
    debugEnabled: false,
    enableFormControl: true,
    enableChildWebView: true,
    enableWebSecurity: true,
    enablePopupBlocker: false
};

});
define('lib/config/user.js', function (require, exports, module) {
module.exports = {
    "version": "1.0.6",
    "id": "blockpuzzle",
    "hasMultiAccess": true,
    "accessList": [
        {
            "uri": "WIDGET_LOCAL",
            "allowSubDomain": true
        },
        {
            "uri": "file:///store/home",
            "allowSubDomain": true
        },
        {
            "uri": "file:///SDCard",
            "allowSubDomain": true
        }
    ],
    "enableFlash": false,
    "autoOrientation": false,
    "autoDeferNetworkingAndJavaScript": true,
    "theme": "default",
    "autoHideSplashScreen": "true",
    "orientation": "portrait",
    "icon": [
        "res/icon/blackberry/icon-80.png"
    ],
    "author": "cranberry",
    "license": "",
    "licenseURL": "http://opensource.org/licenses/alphabetical",
    "content": "local:///index.html",
    "foregroundSource": "index.html",
    "permissions": [],
    "rim:splash": [
        "res/screen/blackberry/splash-1280x768.png",
        "res/screen/blackberry/splash-720x720.png",
        "res/screen/blackberry/splash-768x1280.png"
    ],
    "name": {
        "default": "Block Puzzle"
    },
    "description": {
        "default": "A sample Apache Cordova application that responds to the deviceready event."
    },
    "configXML": "config.xml",
    "buildId": "1",
    "debugEnabled": false
};
});
define('lib/events/applicationEvents.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

module.exports = {
    addEventListener: function (event, trigger) {
        if (event) {
            event = "application." + event;
            window.qnx.webplatform.getApplication().addEventListener(event, trigger);
        } else {
            console.warn("Attempting to register for 'falsey' event: " + event);
        }
    },
    removeEventListener: function (event, trigger) {
        if (event) {
            event = "application." + event;
            window.qnx.webplatform.getApplication().removeEventListener(event, trigger);
        } else {
            console.warn("Attempting to un-register for 'falsey' event: " + event);
        }
    }
};

});
define('lib/events/deviceEvents.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

module.exports = {
    addEventListener: function (event, trigger) {
        if (event) {
            event = "device." + event;
            window.qnx.webplatform.device.addEventListener(event, trigger);
        } else {
            console.warn("Attempting to register for 'falsey' event: " + event);
        }
    },
    removeEventListener: function (event, trigger) {
        if (event) {
            event = "device." + event;
            window.qnx.webplatform.device.removeEventListener(event, trigger);
        } else {
            console.warn("Attempting to un-register for 'falsey' event: " + event);
        }
    }
};

});
define('lib/plugins/default.js', function (require, exports, module) {
/*
 * Copyright 2010-2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var Whitelist = require("../policy/whitelist").Whitelist,
    whitelist = new Whitelist();

module.exports = {

    exec: function (request, succ, fail, args, env) {
        var extPath = "plugin/" + request.params.ext + "/index",
            requestObj = {
                extension: null,
                method: null,
                getExtension: function () {
                    if (frameworkModules.indexOf(extPath + ".js") !== -1) {
                        this.extension = require("../utils").loadModule("../" + extPath);
                        return requestObj;
                    } else {
                        throw {code: 404, msg: "Extension " + request.params.ext + " not found"};
                    }
                },
                getMethod: function () {
                    var methodParts = request.params.method ? request.params.method.split('/') : [request.params.method],
                        extMethod;

                    try {
                        extMethod = this.extension[methodParts.shift()];
                        extMethod = methodParts.reduce(function (previous, current) {
                            if (previous[current]) {
                                return previous[current];
                            } else {
                                throw {code: 404, msg: "Method " + request.params.method + " for " + request.params.ext + " not found"};
                            }
                        }, extMethod);

                        if (extMethod && typeof extMethod === "function") {
                            this.method = extMethod;
                            return requestObj;
                        } else {
                            throw {code: 404, msg: "Method " + request.params.method + " for " + request.params.ext + " not found"};
                        }
                    } catch (e) {
                        throw {code: 404, msg: "Method " + request.params.method + " for " + request.params.ext + " not found"};
                    }
                },
                exec: function () {
                    this.method(succ, fail, args, env);
                }
            };

        try {
            requestObj.getExtension().getMethod().exec();
        } catch (e) {
            console.warn(e.msg);
            fail(-1, e.msg, e.code);
        }
    }
};

});
define('lib/plugins/event.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var _event = require("../../lib/event"),
    ONCE_EVENT_ERROR = "Error occured while adding once event listener.",
    ERROR_ID = -1;

module.exports = {
    once: function (request, success, fail, args, env) {
        try {
            var eventName = decodeURIComponent(args.eventName).replace(/\"/g, ""),
                action = {
                    once: true,
                    event: eventName
                };

            _event.add(action, env.webview);

            if (success) {
                success();
            }
        }
        catch (e) {
            if (fail) {
                fail(ERROR_ID, ONCE_EVENT_ERROR);
            }
        }
    }
};

});
define('lib/policy/folderAccess.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var util = require("../utils");

// Removes the start and end slashes from the path
function _trimSurroundingSlashes(path) {
    // Trim starting slash
    if (util.startsWith(path, "/")) {
        path = path.substr(1);
    }

    // Trim ending slash
    if (util.endsWith(path, "/")) {
        path = path.substr(0, path.length - 1);
    }

    return path;
}

// Determines the depth of the given path
// Folder path must not include the scheme or the host
function _determineDepth(folderPath) {
    var depthCount = 0;

    // Replace all backslashes with forward slash
    folderPath = folderPath.replace("\\", "/");

    // Special case: "/" is the given path
    if (folderPath === "/") {
        return 0;
    }

    folderPath = _trimSurroundingSlashes(folderPath);

    // Count slashes remaining
    while (folderPath.indexOf("/") !== -1) {
        depthCount = depthCount + 1;

        // Add 1 to skip the slash
        folderPath = folderPath.substring(folderPath.indexOf("/") + 1);
    }

    // Add one more for the remaining folder
    depthCount += 1;

    return depthCount;
}

// Parse a folder path up to the desired depth
function _getPath(folderPath, desiredDepth) {
    var depthCount = 0, builtPath = "";

    // Special case: Desired depth is 0
    if (desiredDepth === 0) {
        return "/";
    }

    // Replace all backslashes with forward slash
    folderPath = folderPath.replace("\\", "/");

    folderPath = _trimSurroundingSlashes(folderPath);

    // Count slashes remaining
    while (depthCount < desiredDepth) {
        depthCount += 1;

        // Add 1 to skip the slash
        builtPath += "/" + folderPath.substring(0, folderPath.indexOf('/'));
        folderPath = folderPath.substring(folderPath.indexOf('/') + 1);
    }

    return builtPath;
}

function WebFolderAccessManager() {
    this._pathCollection = {};
    this._maxPathLength = 0;
}

WebFolderAccessManager.prototype.addAccess = function (folderPath, access) {
    if (!folderPath) {
        folderPath = "/";
    }

    // Trim surrounding slashes for consistency
    // The root "/" is a special case that does not need this trimming
    if (folderPath !== "/") {
        folderPath = "/" + _trimSurroundingSlashes(folderPath);
    }

    folderPath = folderPath.toLowerCase();

    this._pathCollection[folderPath] = access;

    // Determine the depth of the path
    this._maxPathLength = Math.max(this._maxPathLength, _determineDepth(folderPath));
};

WebFolderAccessManager.prototype.getAccess = function (folderPath) {
    var depth = _determineDepth(folderPath);
    return this.getAccessRecursively(folderPath, depth);
};

WebFolderAccessManager.prototype.fetchAccess = function (folderPath) {
    var queryIndex, folderPathWildcard;

    if (!this._pathCollection.hasOwnProperty(folderPath)) {
        // If there isn't an exact match and folderPath contains query string,
        // check if the path collection contains an access with the same folderPath
        // but with wildcard query
        if ((queryIndex = folderPath.indexOf("?")) > -1) {
            folderPathWildcard = folderPath.slice(0, queryIndex + 1) + "*";

            if (this._pathCollection.hasOwnProperty(folderPathWildcard)) {
                return this._pathCollection[folderPathWildcard];
            }
        }

        return null;
    } else {
        return this._pathCollection[folderPath];
    }
};

WebFolderAccessManager.prototype.getAccessRecursively = function (folderPath, pathLength) {
    var fetchedAccess,
        newPathLength,
        newPath;

    if (!folderPath) {
        return null;
    }

    folderPath = folderPath.toLowerCase();

    if (!!(fetchedAccess = this.fetchAccess(folderPath))) {
        return fetchedAccess;
    } else {
        // Truncate the end portion of the path and try again
        newPathLength = Math.min(this._maxPathLength, pathLength - 1);
        newPath = _getPath(folderPath, newPathLength);

        return this.getAccessRecursively(newPath, newPathLength);
    }
};

function WebFolderAccess() {
    this._mgr = new WebFolderAccessManager();
}

// folderPath - folder path must not include the scheme or the host
WebFolderAccess.prototype.addAccess = function (folderPath, access) {
    this._mgr.addAccess(folderPath, access);
};

// folderPath - folder path must not include the scheme or the host
WebFolderAccess.prototype.getAccess = function (folderPath) {
    return this._mgr.getAccess(folderPath);
};

exports.WebFolderAccess = WebFolderAccess;

});
define('lib/policy/webkitOriginAccess.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var config = require('./../config'),
    utils = require('./../utils'),
    Whitelist = require('./whitelist').Whitelist,
    LOCAL_URI = "local://",
    FILE_URI = "file://",
    WW_URI = utils.getURIPrefix(),
    _domains = [
        {
            url: LOCAL_URI,
            allowSubDomains: true
        }
    ],
    _webviews = [],
    _isInitialized = false,
    _whitelist = new Whitelist();

function addOriginAccessWhitelistEntry(webview, source, destination, allowSubDomains) {
    webview.addOriginAccessWhitelistEntry(source, destination, !!allowSubDomains);
}

function addDomain(url, allowSubDomains) {
    var parsedUri = utils.parseUri(url);

    allowSubDomains = !!allowSubDomains;

    if (utils.isLocalURI(parsedUri)) {
        url = LOCAL_URI;
    } else if (utils.isFileURI(parsedUri)) {
        url = FILE_URI;
    } else {
        url = parsedUri.source;
    }

    if (_whitelist.isAccessAllowed(url) && !_domains.some(function (domain) {
        return domain.url === url;
    })) {
        _webviews.forEach(function (webview) {
            addOriginAccessWhitelistEntry(webview, url, WW_URI, true);

            _domains.forEach(function (domain) {
                addOriginAccessWhitelistEntry(webview, domain.url, url, allowSubDomains);
                addOriginAccessWhitelistEntry(webview, url, domain.url, domain.allowSubDomains);
            });

        });

        _domains.push({
            url: url,
            allowSubDomains: allowSubDomains
        });
    }
}

function initializeDomains() {
    var accessElements = config.accessList;

    accessElements.forEach(function (element, index, array) {
        var uri = (element.uri === 'WIDGET_LOCAL' ? LOCAL_URI : element.uri);
        addDomain(uri, !!element.allowSubDomain);
    });
}

function initializaWebview(webview) {
    //Always allow file access from local and let the OS deal with permissions
    addOriginAccessWhitelistEntry(webview, LOCAL_URI, FILE_URI, true);
    addOriginAccessWhitelistEntry(webview, FILE_URI, LOCAL_URI, true);
    //Always allow LOCAL access to URIs
    addOriginAccessWhitelistEntry(webview, LOCAL_URI, WW_URI, true);

    _domains.forEach(function (domain, domainIndex, domainArray) {
        var i,
            nextDomain;

        if (domain.uri !== LOCAL_URI) {
            addOriginAccessWhitelistEntry(webview, domain.url, WW_URI, true);
        }

        for (i = domainIndex + 1; i < domainArray.length; i++) {
            nextDomain = domainArray[i];
            addOriginAccessWhitelistEntry(webview, domain.url, nextDomain.url, nextDomain.allowSubDomains);
            addOriginAccessWhitelistEntry(webview, nextDomain.url, domain.url, domain.allowSubDomains);
        }
    });

}

module.exports = {

    addWebView: function (webview) {
        if (_webviews.indexOf(webview) === -1) {
            _webviews.push(webview);
            initializaWebview(webview);
            if (!_isInitialized) {
                initializeDomains();
                _isInitialized = true;
            }
        }
    },

    addOriginAccess: function (origin, allowSubDomains) {
        if (!_isInitialized) {
            initializeDomains();
            _isInitialized = true;
        }
        addDomain(origin, allowSubDomains);
    }
};

});
define('lib/policy/whitelist.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var WebFolderAccess = require("./folderAccess").WebFolderAccess,
    util = require("../utils");

function _isLocalAccess(access) {
    return access && access.uri === "WIDGET_LOCAL";
}

function _isMatch(access, requestURI) {
    // Look for local first
    if (_isLocalAccess(access)) {
        // Local access always allowed
        //THIS USED TO RETURN TRUE FOR FILE ACCESS
        //I HAVE TURNED IT OFF BECAUSE IT MAKES NO SENSE THAT LOCAL ACCESS ALWAYS MATCHES FILE ACCESS
        return (util.isLocalURI(requestURI));
    } else if (util.isDataURI(requestURI)) {
        // Check for data url
        // data urls are allowed
        return true;
    }

    // Based on widgets 1.0 (access control)
    // http://www.w3.org/TR/2009/WD-widgets-access-20090618/#rfc3987
    var refURI = util.parseUri(access.uri),
        allowSub = access.allowSubDomain;

    if (!requestURI.path) {
        requestURI.path = "/";
    }

    // Start comparison based on widget spec.
    // 1. Compare scheme
    if (refURI.scheme.toLowerCase() !== requestURI.scheme.toLowerCase()) {
        return false;
    }

    // 2. Compare host - if subdoman is false, host must match exactly
    // (referenceURI MUST HAVE host specified - not null.)
    // Special Case: Ignore this condition if we are dealing with file://
    if (!requestURI.authority && !util.isFileURI(requestURI)) {
        return false;
    }

    if (!allowSub && refURI.host.toLowerCase() !== requestURI.host.toLowerCase()) {
        return false;
    }

    // 3. Compare host - if subdomain is true, check for subdomain or match
    if (allowSub && !util.endsWith(requestURI.host.toLowerCase(), "." + refURI.host.toLowerCase()) &&
        requestURI.host.toLowerCase() !== refURI.host.toLowerCase()) {
        return false;
    }

    // 4. Compare port
    if (refURI.port && refURI.port !== requestURI.port) {
        return false;
    }

    // 5.  Compare path+query
    if (!util.startsWith(requestURI.path.toLowerCase(), refURI.path.toLowerCase()) && refURI.query !== "*") {
        return false;
    }

    return true;
}

function _getAccessForPathAndQuery(folderAccess, path, query) {
    if (folderAccess) {
        if (!query) {
            return folderAccess.getAccess(path);
        } else {
            return folderAccess.getAccess(path + "?" + query);
        }
    }

    return null;
}

function AccessManager(config) {
    config = config || require("../config");

    this._accessList = config.accessList;
    this._hasGlobalAccess = config.hasMultiAccess;
    this._authorityCollection = null;
    this._localAccess = null;
}

AccessManager.prototype.getFolderAccess = function (scheme, authority) {
    var key = scheme + "://" + authority;
    key = key.toLowerCase();

    if (this._authorityCollection.hasOwnProperty(key)) {
        return this._authorityCollection[key];
    }

    return null;
};

AccessManager.prototype.putFolderAccess = function (scheme, authority, folderAccess) {
    var key = scheme + "://" + authority;
    key = key.toLowerCase();
    this._authorityCollection[key] = folderAccess;
};

AccessManager.prototype.initializeAuthCollection = function () {
    var folderAccess, currentURI, that = this;

    if (!this._authorityCollection) {
        this._authorityCollection = {};

        if (this._accessList) {
            this._accessList.forEach(function (access) {
                if (_isLocalAccess(access)) {
                    that._localAccess = access;
                } else {
                    currentURI = util.parseUri(access.uri);

                    // Check the authority collection to see if the authority item
                    // we want already exists
                    folderAccess = that.getFolderAccess(currentURI.scheme, currentURI.authority) || new WebFolderAccess();

                    // Add folder path access to the authority item
                    if (!currentURI.query) {
                        folderAccess.addAccess(currentURI.path, access);
                    } else {
                        folderAccess.addAccess(currentURI.path + "?" + currentURI.query, access);
                    }

                    that.putFolderAccess(currentURI.scheme, currentURI.authority, folderAccess);
                }
            });
        }
    }
};

AccessManager.prototype.authorityCheck = function (port, scheme, authority) {
    var originalAuthority = authority;

    if (port) {
        // If authority has a specific port, and the collection does not have an access matches
        // the exact authority, strip port from authority to see if there is a match
        if (!this.getFolderAccess(scheme, authority)) {
            authority = authority.slice(0, authority.lastIndexOf(":"));
            authority = this.authorityCheck("", scheme, authority);
        }

        //If no successful match was found without the port, reset the authority and try with it
        if (!this.getFolderAccess(scheme, authority)) {
            authority = originalAuthority;
        }
    }

    if (authority.indexOf(".") === -1) {
        // If authority is computer name, must have exact match in collection
        if (!this.getFolderAccess(scheme, authority)) {
            return "";
        }

        return authority;
    }

    while (authority && !this.getFolderAccess(scheme, authority)) {
        if (authority.indexOf(".") === -1) {
            return "";
        }
        authority = authority.substring(authority.indexOf(".") + 1);
    }

    return authority;
};

AccessManager.prototype.getFromFolderAccess = function (folderAccess, requestURI) {
    var fetchedAccess = null,
        scheme = requestURI.scheme,
        authority = requestURI.authority,
        path = requestURI.path,
        query = requestURI.query,
        prevAuthority;

    if (!path) {
        fetchedAccess = folderAccess.getAccess("/");
    } else {
        fetchedAccess = _getAccessForPathAndQuery(folderAccess, path, query);
    }

    // Make sure we've got the right one
    while (!fetchedAccess || !_isMatch(fetchedAccess, requestURI)) {
        // There was an auth url that matched, but didnt match the folder structure
        // Try the next level up
        prevAuthority = authority;
        authority = authority.substring(authority.indexOf(".") + 1);
        //If authority hasn't changed, then this loop will continue endlessly because nothing else has changed
        //This will happen when an element has the same authority but no folder access.
        if (prevAuthority === authority) {
            return null;
        }

        // Check for an authority string that has an existing key
        authority = this.authorityCheck(requestURI.port, scheme, authority);
        if (!authority) {
            return null;
        }

        // Retrieve access set for the specified authority
        folderAccess = this.getFolderAccess(scheme, authority);

        // Special case: no access element was found for a file protocol request.
        // This is added since file protocol was allowed through the above check
        if (scheme === "file" && !folderAccess) {
            return null;
        }

        fetchedAccess = _getAccessForPathAndQuery(folderAccess, path, query);
    }

    return fetchedAccess;
};

AccessManager.prototype.getAccessByUrl = function (url) {
    var requestURI = util.parseUri(url),
        authority = requestURI.authority,
        scheme = requestURI.scheme,
        folderAccess,
        fetchedAccess;

    if (util.isAbsoluteURI(requestURI)) {
        // Initialize authority collection if it does not yet exist
        this.initializeAuthCollection();

        // Start with the full authority path and check if an access exists for that path
        // If it does not exist, remove the first section of the authority path and try again

        // Check for an authority string that has an existing key
        // Special case: Allow file, and local protocol to proceed without an authority
        authority = this.authorityCheck(requestURI.port, scheme, authority);
        if (!authority && !(scheme === "file" || scheme === "local" || scheme === "data")) {
            return null;
        }
        // Retrieve access set for the specified authority
        folderAccess = this.getFolderAccess(scheme, authority);

        // Special case: no access was found for a file protocol request
        // This is added since file protocol was allowed through the above check
        if (scheme === "file" && !folderAccess) {
            return null;
        } else if (scheme === "local" && !folderAccess) {
            // If no access element is found with local URI, use local access for this request
            return this._localAccess;
        } else if (scheme === "data") {
            // Always allow data-uris
            return true;
        }

        fetchedAccess = this.getFromFolderAccess(folderAccess, requestURI);

        if (fetchedAccess) {
            return fetchedAccess;
        } else if (this._localAccess && _isMatch(this._localAccess, requestURI)) {
            // If we cannot find a more specific access for this local URI, use local access
            return this._localAccess;
        } else if (folderAccess && _isMatch(folderAccess, requestURI)) {
            return folderAccess;
        }
    }

    return null;
};

AccessManager.prototype.hasGlobalAccess = function () {
    return this._hasGlobalAccess;
};

function Whitelist(config) {
    this._mgr = new AccessManager(config);
}

Whitelist.prototype.getFeaturesForUrl = function (url) {
    var access = this._mgr.getAccessByUrl(url),
        featureIds = [];

    if (access && access.features) {
        access.features.forEach(function (elem) {
            featureIds.push(elem.id);
        });
    }

    return featureIds;
};

Whitelist.prototype.isFeatureAllowed = function (url, feature) {
    var features = this.getFeaturesForUrl(url);

    return !!features && features.reduce(function (found, current) {
        return found || current === feature;
    }, false);
};

Whitelist.prototype.isAccessAllowed = function (url, isXHR) {
    return (this._mgr.hasGlobalAccess() && !isXHR) || !!this._mgr.getAccessByUrl(url);
};

exports.Whitelist = Whitelist;

});
define('lib/webkitHandlers/networkResourceRequested.js', function (require, exports, module) {
/*
 *  Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var Whitelist = require('../policy/whitelist').Whitelist,
    ACCEPT_RESPONSE = {setAction: "ACCEPT"},
    DENY_RESPONSE = {setAction: "DENY"},
    SUBSTITUTE_RESPONSE = {setAction: "SUBSTITUTE"},
    utils = require('../utils');

function _formMessage(url, origin, sid, body, securityOrigin, webview) {
    var tokens = url.split(utils.getURIPrefix())[1].split("/"),
        //Handle the case where the method is multi-level
        finalToken = (tokens[3] && tokens.length > 4) ? tokens.slice(3).join('/') : tokens[3];

    return {
        request : {
            params : {
                service : tokens[0],
                action : tokens[1],
                ext : tokens[2],
                method : (finalToken && finalToken.indexOf("?") >= 0) ? finalToken.split("?")[0] : finalToken,
                args : (finalToken && finalToken.indexOf("?") >= 0) ? finalToken.split("?")[1] : null
            },
            body : body,
            origin : origin,
            securityOrigin: securityOrigin

        },
        response : {
            send : function (code, data) {
                var responseText;
                if (typeof(data) === 'string') {
                    responseText = data;
                } else {
                    responseText =  JSON.stringify(data);
                }

                webview.notifyOpen(sid, code, "OK");
                webview.notifyHeaderReceived(sid, "Access-Control-Allow-Origin", "*");
                webview.notifyHeaderReceived(sid, "Access-Control-Allow-Origin", securityOrigin);
                webview.notifyHeaderReceived(sid, "Access-Control-Allow-Headers", "Content-Type");
                webview.notifyDataReceived(sid, responseText, responseText.length);
                webview.notifyDone(sid);
            }
        }
    };
}

function networkResourceRequestedHandler(value) {
    var config = require("./../config"),
        obj = JSON.parse(value),
        response,
        url = obj.url,
        body = obj.body,
        whitelist = new Whitelist(),
        server,
        message,
        sid = obj.streamId,
        origin = obj.referrer,
        securityOrigin = obj.securityOrigin,
        isXHR = obj.targetType === "TargetIsXMLHTTPRequest",
        //Assumes its a navigation request if the target is the main frame
        isNav = obj.targetType === "TargetIsMainFrame",
        hasAccess = whitelist.isAccessAllowed(url, isXHR),
        deniedMsg;

    //If the URL starts with the prefix then its a request from an API
    //In this case we will hijack and give our own response
    //Otherwise follow whitelisting rules
    if (url.match("^" + utils.getURIPrefix())) {
        server = require("../server");
        message = _formMessage(url, origin, sid, body, securityOrigin, this.webview, config);
        response = SUBSTITUTE_RESPONSE;
        server.handle(message.request, message.response, this.webview);
    } else {
        //Whitelisting will not prevent navigation, ONLY we will
        //Except when they've disabled web security
        if (hasAccess || !config.enableWebSecurity) {
            response = ACCEPT_RESPONSE;
        } else {
            response = DENY_RESPONSE;
            url = utils.parseUri(url);
            deniedMsg = "Access to \"" + url.source + "\" not allowed";

            console.warn(deniedMsg);

            //Denied navigation requests are sent to the inApp browser rather than an alert
            if (isNav) {
                if (config.enableChildWebView) {
                    this.webview.uiWebView.childwebviewcontrols.open(url.source);
                } else {
                    utils.invokeInBrowser(url.source);
                }
            } else {
                this.webview.executeJavaScript("alert('" + deniedMsg + "')");
            }
        }
    }

    if (response) {
        return JSON.stringify(response);
    }
}

function NetworkResourceRequestHandler(webview) {
    this.webview = webview;
    this.networkResourceRequestedHandler = networkResourceRequestedHandler.bind(this);
}

module.exports = {
    createHandler: function (webview) {
        return new NetworkResourceRequestHandler(webview);
    }
};

});
define('plugin/Accelerometer/index.js', function (require, exports, module) {
/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
*/

var callback;

module.exports = {
    start: function (success, fail, args, env) {
        var result = new PluginResult(args, env);
        window.removeEventListener("devicemotion", callback);
        callback = function (motion) {
            var info = {
                x: motion.accelerationIncludingGravity.x,
                y: motion.accelerationIncludingGravity.y,
                z: motion.accelerationIncludingGravity.z,
                timestamp: motion.timestamp
            };
            result.callbackOk(info, true);
        };
        window.addEventListener("devicemotion", callback);
        result.noResult(true);
    },
    stop: function (success, fail, args, env) {
        var result = new PluginResult(args, env);
        window.removeEventListener("devicemotion", callback);
        result.ok("removed");
    }
};

});
define('plugin/Battery/index.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

    var _clientListeners = {},
        _webkitBattery = navigator.webkitBattery || navigator.battery;

module.exports = {
    start: function (success, fail, args, env) {
        var result = new PluginResult(args, env),
            listener = function (info) {
                var resultInfo = {};
                if (info) {
                    if (info.srcElement) {
                        //webkitBattery listeners store webkitBattery in srcElement object
                        info = info.srcElement;
                    }

                    //put data from webkitBattery into a format cordova expects
                    //webkitBattery seems to return level as a decimal pre 10.2
                    resultInfo.level = info.level <= 1 ? info.level * 100 : info.level,
                    resultInfo.isPlugged = info.charging
                }

                result.callbackOk(resultInfo, true);
            };

        if (_clientListeners[env.webview.id]) {
            //TODO: Change back to erroring out after reset is implemented
            //result.error("Battery listener already running");
            _webkitBattery.onchargingchange = null;
            _webkitBattery.onlevelchange = null;
        }

        _clientListeners[env.webview.id] = listener;

        _webkitBattery.onchargingchange = listener;
        _webkitBattery.onlevelchange = listener;

        setTimeout(function(){
            //Call callback with webkitBattery data right away
            listener(_webkitBattery);
        });

        result.noResult(true);
    },
    stop: function (success, fail, args, env) {
        var result = new PluginResult(args, env),
            listener = _clientListeners[env.webview.id];

        if (!listener) {
            result.error("Battery listener has not started");
        } else {
            _webkitBattery.onchargingchange = null;
            _webkitBattery.onlevelchange = null;
            delete _clientListeners[env.webview.id];
            result.noResult(false);
        }
    }
};

});
define('plugin/Camera/index.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var PictureSourceType = {
        PHOTOLIBRARY : 0,    // Choose image from picture library (same as SAVEDPHOTOALBUM for Android)
        CAMERA : 1,          // Take picture from camera
        SAVEDPHOTOALBUM : 2  // Choose image from picture library (same as PHOTOLIBRARY for Android)
    },
    DestinationType = {
        DATA_URL: 0,         // Return base64 encoded string
        FILE_URI: 1,         // Return file uri (content://media/external/images/media/2 for Android)
        NATIVE_URI: 2        // Return native uri (eg. asset-library://... for iOS)
    };

function encodeBase64(filePath, callback) {
    var sandbox = window.qnx.webplatform.getController().setFileSystemSandbox, // save original sandbox value
        errorHandler = function (err) {
            var msg = "An error occured: ";

            switch (err.code) {
            case FileError.NOT_FOUND_ERR:
                msg += "File or directory not found";
                break;

            case FileError.NOT_READABLE_ERR:
                msg += "File or directory not readable";
                break;

            case FileError.PATH_EXISTS_ERR:
                msg += "File or directory already exists";
                break;

            case FileError.TYPE_MISMATCH_ERR:
                msg += "Invalid file type";
                break;

            default:
                msg += "Unknown Error";
                break;
            };

            // set it back to original value
            window.qnx.webplatform.getController().setFileSystemSandbox = sandbox;
            callback(msg);
        },
        gotFile = function (fileEntry) {
            fileEntry.file(function (file) {
                var reader = new FileReader();

                reader.onloadend = function (e) {
                    // set it back to original value
                    window.qnx.webplatform.getController().setFileSystemSandbox = sandbox;
                    callback(this.result);
                };

                reader.readAsDataURL(file);
            }, errorHandler);
        },
        onInitFs = function (fs) {
            window.qnx.webplatform.getController().setFileSystemSandbox = false;
            fs.root.getFile(filePath, {create: false}, gotFile, errorHandler);
        };

    window.webkitRequestFileSystem(window.TEMPORARY, 10 * 1024 * 1024, onInitFs, errorHandler); // set size to 10MB max
}

module.exports = {
    takePicture: function (success, fail, args, env) {
        var destinationType = JSON.parse(decodeURIComponent(args[1])),
            sourceType = JSON.parse(decodeURIComponent(args[2])),
            result = new PluginResult(args, env),
            done = function (data) {
                if (destinationType === DestinationType.FILE_URI) {
                    data = "file://" + data;
                    result.callbackOk(data, false);
                } else {
                    encodeBase64(data, function (data) {
                        if (/^data:/.test(data)) {
                            data = data.slice(data.indexOf(",") + 1);
                            result.callbackOk(data, false);
                        } else {
                            result.callbackError(data, false);
                        }
                    });
                }
            },
            cancel = function (reason) {
                result.callbackError(reason, false);
            },
            invoked = function (error) {
                if (error) {
                    result.callbackError(error, false);
                }
            };

        switch(sourceType) {
        case PictureSourceType.CAMERA:
            window.qnx.webplatform.getApplication().cards.camera.open("photo", done, cancel, invoked);
            break;

        case PictureSourceType.PHOTOLIBRARY:
        case PictureSourceType.SAVEDPHOTOALBUM:
            window.qnx.webplatform.getApplication().cards.filePicker.open({
                mode: "Picker",
                type: ["picture"]
            }, done, cancel, invoked);
            break;
        }

        result.noResult(true);
    }
};

});
define('plugin/Contacts/index.js', function (require, exports, module) {
/*
 * Copyright 2013 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var pimContacts,
    contactUtils = require("./contactUtils"),
    contactConsts = require("./contactConsts"),
    ContactError = require("./ContactError"),
    ContactName = require("./ContactName"),
    ContactFindOptions = require("./ContactFindOptions"),
    noop = function () {};

function getAccountFilters(options) {
    if (options.includeAccounts) {
        options.includeAccounts = options.includeAccounts.map(function (acct) {
            return acct.id.toString();
        });
    }

    if (options.excludeAccounts) {
        options.excludeAccounts = options.excludeAccounts.map(function (acct) {
            return acct.id.toString();
        });
    }
}

function populateSearchFields(fields) {
    var i,
        l,
        key,
        searchFieldsObject = {},
        searchFields = [];

    for (i = 0, l = fields.length; i < l; i++) {
        if (fields[i] === "*") {
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_GIVEN_NAME] = true;
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_FAMILY_NAME] = true;
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_PHONE] = true;
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_EMAIL] = true;
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_ORGANIZATION_NAME] = true;
        } else if (fields[i] === "displayName" || fields[i] === "name") {
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_GIVEN_NAME] = true;
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_FAMILY_NAME] = true;
        } else if (fields[i] === "nickname") {
            // not supported by Cascades
        } else if (fields[i] === "phoneNumbers") {
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_PHONE] = true;
        } else if (fields[i] === "emails") {
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_EMAIL] = true;
        } else if (field === "addresses") {
            // not supported by Cascades
        } else if (field === "ims") {
            // not supported by Cascades
        } else if (field === "organizations") {
            searchFieldsObject[ContactFindOptions.SEARCH_FIELD_ORGANIZATION_NAME] = true;
        } else if (field === "birthday") {
            // not supported by Cascades
        } else if (field === "note") {
            // not supported by Cascades
        } else if (field === "photos") {
            // not supported by Cascades
        } else if (field === "categories") {
            // not supported by Cascades
        } else if (field === "urls") {
            // not supported by Cascades
        }
    }

    for (key in searchFieldsObject) {
        if (searchFieldsObject.hasOwnProperty(key)) {
            searchFields.push(window.parseInt(key));
        }
    }

    return searchFields;
}

function convertBirthday(birthday) {
    //Convert date string from native to milliseconds since epoch for cordova-js
    var birthdayInfo;
    if (birthday) {
        birthdayInfo = birthday.split("-");
        return new Date(birthdayInfo[0], birthdayInfo[1] - 1, birthdayInfo[2]).getTime();
    } else {
        return null;
    }
}

function processJnextSaveData(result, JnextData) {
    var data = JnextData,
        birthdayInfo;

    if (data._success === true) {
        data.birthday = convertBirthday(data.birthday);
        result.callbackOk(data, false);
    } else {
        result.callbackError(data.code, false);
    }
}

function processJnextRemoveData(result, JnextData) {
    var data = JnextData;

    if (data._success === true) {
        result.callbackOk(data);
    } else {
        result.callbackError(ContactError.UNKNOWN_ERROR, false);
    }
}

function processJnextFindData(eventId, eventHandler, JnextData) {
    var data = JnextData,
        i,
        l,
        more = false,
        resultsObject = {},
        birthdayInfo;

    if (data.contacts) {
        for (i = 0, l = data.contacts.length; i < l; i++) {
            data.contacts[i].birthday = convertBirthday(data.contacts[i].birthday);
            data.contacts[i].name = new ContactName(data.contacts[i].name);
        }
    } else {
        data.contacts = []; // if JnextData.contacts return null, return an empty array
    }

    if (data._success === true) {
        eventHandler.error = false;
    }

    if (eventHandler.multiple) {
        // Concatenate results; do not add the same contacts
        for (i = 0, l = eventHandler.searchResult.length; i < l; i++) {
            resultsObject[eventHandler.searchResult[i].id] = true;
        }

        for (i = 0, l = data.contacts.length; i < l; i++) {
            if (resultsObject[data.contacts[i].id]) {
                // Already existing
            } else {
                eventHandler.searchResult.push(data.contacts[i]);
            }
        }

        // check if more search is required
        eventHandler.searchFieldIndex++;
        if (eventHandler.searchFieldIndex < eventHandler.searchFields.length) {
            more = true;
        }
    } else {
        eventHandler.searchResult = data.contacts;
    }

    if (more) {
        pimContacts.getInstance().invokeJnextSearch(eventId);
    } else {
        if (eventHandler.error) {
            eventHandler.result.callbackError(data.code, false);
        } else {
            eventHandler.result.callbackOk(eventHandler.searchResult, false);
        }
    }
}

module.exports = {
    search: function (successCb, failCb, args, env) {
        var cordovaFindOptions = {},
            result = new PluginResult(args, env),
            key;

        for (key in args) {
            if (args.hasOwnProperty(key)) {
                cordovaFindOptions[key] = JSON.parse(decodeURIComponent(args[key]));
            }
        }

        pimContacts.getInstance().find(cordovaFindOptions, result, processJnextFindData);
        result.noResult(true);
    },
    save: function (successCb, failCb, args, env) {
        var attributes = {},
            result = new PluginResult(args, env),
            key,
            nativeEmails = [];

        attributes = JSON.parse(decodeURIComponent(args[0]));

        //convert birthday format for our native .so file
        if (attributes.birthday) {
            attributes.birthday = new Date(attributes.birthday).toDateString();
        }

        if (attributes.emails) {
            attributes.emails.forEach(function (email) {
                if (email.value) {
                    if (email.type) {
                        nativeEmails.push({ "type" : email.type, "value" : email.value });
                    } else {
                        nativeEmails.push({ "type" : "home", "value" : email.value });
                    }
                }
            });
            attributes.emails = nativeEmails;
        }

        if (attributes.id !== null) {
            attributes.id = window.parseInt(attributes.id);
        }

        attributes._eventId = result.callbackId;
        pimContacts.getInstance().save(attributes, result, processJnextSaveData);
        result.noResult(true);
    },
    remove: function (successCb, failCb, args, env) {
        var result = new PluginResult(args, env),
            attributes = {
                "contactId": window.parseInt(JSON.parse(decodeURIComponent(args[0]))),
                "_eventId": result.callbackId
            };

        if (!window.isNaN(attributes.contactId)) {
            pimContacts.getInstance().remove(attributes, result, processJnextRemoveData);
            result.noResult(true);
        } else {
            result.error(ContactError.UNKNOWN_ERROR);
            result.noResult(false);
        }
    }
};

///////////////////////////////////////////////////////////////////
// JavaScript wrapper for JNEXT plugin
///////////////////////////////////////////////////////////////////

JNEXT.PimContacts = function ()
{
    var self = this,
        hasInstance = false;

    self.find = function (cordovaFindOptions, pluginResult, handler) {
        //register find eventHandler for when JNEXT onEvent fires
        self.eventHandlers[cordovaFindOptions.callbackId] = {
            "result" : pluginResult,
            "action" : "find",
            "multiple" : cordovaFindOptions[1].filter ? true : false,
            "fields" : cordovaFindOptions[0],
            "searchFilter" : cordovaFindOptions[1].filter,
            "searchFields" : cordovaFindOptions[1].filter ? populateSearchFields(cordovaFindOptions[0]) : null,
            "searchFieldIndex" : 0,
            "searchResult" : [],
            "handler" : handler,
            "error" : true
        };

        self.invokeJnextSearch(cordovaFindOptions.callbackId);
        return "";
    };

    self.invokeJnextSearch = function(eventId) {
        var jnextArgs = {},
            findHandler = self.eventHandlers[eventId];

        jnextArgs._eventId = eventId;
        jnextArgs.fields = findHandler.fields;
        jnextArgs.options = {};
        jnextArgs.options.filter = [];

        if (findHandler.multiple) {
            jnextArgs.options.filter.push({
                "fieldName" : findHandler.searchFields[findHandler.searchFieldIndex],
                "fieldValue" : findHandler.searchFilter
            });
            //findHandler.searchFieldIndex++;
        }

        JNEXT.invoke(self.m_id, "find " + JSON.stringify(jnextArgs));
    }

    self.getContact = function (args) {
        return JSON.parse(JNEXT.invoke(self.m_id, "getContact " + JSON.stringify(args)));
    };

    self.save = function (args, pluginResult, handler) {
        //register save eventHandler for when JNEXT onEvent fires
        self.eventHandlers[args._eventId] = {
            "result" : pluginResult,
            "action" : "save",
            "handler" : handler
        };
        JNEXT.invoke(self.m_id, "save " + JSON.stringify(args));
        return "";
    };

    self.remove = function (args, pluginResult, handler) {
        //register remove eventHandler for when JNEXT onEvent fires
        self.eventHandlers[args._eventId] = {
            "result" : pluginResult,
            "action" : "remove",
            "handler" : handler
        };
        JNEXT.invoke(self.m_id, "remove " + JSON.stringify(args));
        return "";
    };

    self.getId = function () {
        return self.m_id;
    };

    self.getContactAccounts = function () {
        var value = JNEXT.invoke(self.m_id, "getContactAccounts");
        return JSON.parse(value);
    };

    self.init = function () {
        if (!JNEXT.require("libpimcontacts")) {
            return false;
        }

        self.m_id = JNEXT.createObject("libpimcontacts.PimContacts");

        if (self.m_id === "") {
            return false;
        }

        JNEXT.registerEvents(self);
    };

    // Handle data coming back from JNEXT native layer. Each async function registers a handler and a PluginResult object.
    // When JNEXT fires onEvent we parse the result string  back into JSON and trigger the appropriate handler (eventHandlers map
    // uses callbackId as key), along with the actual data coming back from the native layer. Each function may have its own way of
    // processing native data so we do not do any processing here.

    self.onEvent = function (strData) {
        var arData = strData.split(" "),
            strEventDesc = arData[0],
            eventHandler,
            args = {};

        if (strEventDesc === "result") {
            args.result = escape(strData.split(" ").slice(2).join(" "));
            eventHandler = self.eventHandlers[arData[1]];
            if (eventHandler.action === "save" || eventHandler.action === "remove") {
                eventHandler.handler(eventHandler.result, JSON.parse(decodeURIComponent(args.result)));
            } else if (eventHandler.action === "find") {
                eventHandler.handler(arData[1], eventHandler, JSON.parse(decodeURIComponent(args.result)));
            }
        }
    };

    self.m_id = "";
    self.eventHandlers = {};

    self.getInstance = function () {
        if (!hasInstance) {
            self.init();
            hasInstance = true;
        }
        return self;
    };
};

pimContacts = new JNEXT.PimContacts();

});
define('plugin/Contacts/ContactActivity.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var ContactActivity = function (args) {
    this.direction = args.direction || null;
    this.description = args.description || "";
    this.mimeType = args.mimeType || "";
    this.timestamp = new Date(parseInt(args.timestamp, 10)) || null;
};

Object.defineProperty(ContactActivity, "INCOMING", {"value": true});
Object.defineProperty(ContactActivity, "OUTGOING", {"value": false});

module.exports = ContactActivity;
});
define('plugin/Contacts/ContactAddress.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var ContactAddress = function (properties) {
    this.type = properties && properties.type ? properties.type : "";
    this.streetAddress = properties && properties.streetAddress ? properties.streetAddress : "";
    this.streetOther = properties && properties.streetOther ? properties.streetOther : "";
    this.locality = properties && properties.locality ? properties.locality : "";
    this.region = properties && properties.region ? properties.region : "";
    this.postalCode = properties && properties.postalCode ? properties.postalCode : "";
    this.country = properties && properties.country ? properties.country : "";
};

Object.defineProperty(ContactAddress, "HOME", {"value": "home"});
Object.defineProperty(ContactAddress, "WORK", {"value": "work"});
Object.defineProperty(ContactAddress, "OTHER", {"value": "other"});

module.exports = ContactAddress;

});
define('plugin/Contacts/contactConsts.js', function (require, exports, module) {
/*
* Copyright 2012 Research In Motion Limited.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

var ATTRIBUTE_KIND,
    ATTRIBUTE_SUBKIND,
    kindAttributeMap = {},
    subKindAttributeMap = {},
    _TITLE = 26,
    _START_DATE = 43,
    _END_DATE = 44;

function populateKindAttributeMap() {
    ATTRIBUTE_KIND = {
        Invalid: 0,
        Phone: 1,
        Fax: 2,
        Pager: 3,
        Email: 4,
        Website: 5,
        Feed: 6,
        Profile: 7,
        Family: 8,
        Person: 9,
        Date: 10,
        Group: 11,
        Name: 12,
        StockSymbol: 13,
        Ranking: 14,
        OrganizationAffiliation: 15,
        Education: 16,
        Note: 17,
        InstantMessaging: 18,
        VideoChat: 19,
        ConnectionCount: 20,
        Hidden: 21,
        Biography: 22,
        Sound: 23,
        Notification: 24,
        MessageSound: 25,
        MessageNotification: 26
    };

    kindAttributeMap[ATTRIBUTE_KIND.Phone] = "phoneNumbers";
    kindAttributeMap[ATTRIBUTE_KIND.Fax] = "faxNumbers";
    kindAttributeMap[ATTRIBUTE_KIND.Pager] = "pagerNumber";
    kindAttributeMap[ATTRIBUTE_KIND.Email] = "emails";
    kindAttributeMap[ATTRIBUTE_KIND.Website] = "urls";
    kindAttributeMap[ATTRIBUTE_KIND.Profile] = "socialNetworks";
    kindAttributeMap[ATTRIBUTE_KIND.OrganizationAffiliation] = "organizations";
    kindAttributeMap[ATTRIBUTE_KIND.Education] = "education";
    kindAttributeMap[ATTRIBUTE_KIND.Note] = "note";
    kindAttributeMap[ATTRIBUTE_KIND.InstantMessaging] = "ims";
    kindAttributeMap[ATTRIBUTE_KIND.VideoChat] = "videoChat";
    kindAttributeMap[ATTRIBUTE_KIND.Sound] = "ringtone";
}

function populateSubKindAttributeMap() {
    ATTRIBUTE_SUBKIND = {
        Invalid: 0,
        Other: 1,
        Home: 2,
        Work: 3,
        PhoneMobile: 4,
        FaxDirect: 5,
        Blog: 6,
        WebsiteResume: 7,
        WebsitePortfolio: 8,
        WebsitePersonal: 9,
        WebsiteCompany: 10,
        ProfileFacebook: 11,
        ProfileTwitter: 12,
        ProfileLinkedIn: 13,
        ProfileGist: 14,
        ProfileTungle: 15,
        FamilySpouse: 16,
        FamilyChild: 17,
        FamilyParent: 18,
        PersonManager: 19,
        PersonAssistant: 20,
        DateBirthday: 21,
        DateAnniversary: 22,
        GroupDepartment: 23,
        NameGiven: 24,
        NameSurname: 25,
        Title: _TITLE,
        NameSuffix: 27,
        NameMiddle: 28,
        NameNickname: 29,
        NameAlias: 30,
        NameDisplayName: 31,
        NamePhoneticGiven: 32,
        NamePhoneticSurname: 33,
        StockSymbolNyse: 34,
        StockSymbolNasdaq: 35,
        StockSymbolTse: 36,
        StockSymbolLse: 37,
        StockSymbolTsx: 38,
        RankingKlout: 39,
        RankingTrstRank: 40,
        OrganizationAffiliationName: 41,
        OrganizationAffiliationPhoneticName: 42,
        OrganizationAffiliationTitle: _TITLE,
        StartDate: _START_DATE,
        EndDate: _END_DATE,
        OrganizationAffiliationDetails: 45,
        EducationInstitutionName: 46,
        EducationStartDate: _START_DATE,
        EducationEndDate: _END_DATE,
        EducationDegree: 47,
        EducationConcentration: 48,
        EducationActivities: 49,
        EducationNotes: 50,
        InstantMessagingBbmPin: 51,
        InstantMessagingAim: 52,
        InstantMessagingAliwangwang: 53,
        InstantMessagingGoogleTalk: 54,
        InstantMessagingSametime: 55,
        InstantMessagingIcq: 56,
        InstantMessagingIrc: 57,
        InstantMessagingJabber: 58,
        InstantMessagingMsLcs: 59,
        InstantMessagingMsn: 60,
        InstantMessagingQq: 61,
        InstantMessagingSkype: 62,
        InstantMessagingYahooMessenger: 63,
        InstantMessagingYahooMessengerJapan: 64,
        VideoChatBbPlaybook: 65,
        HiddenLinkedIn: 66,
        HiddenFacebook: 67,
        HiddenTwitter: 68,
        ConnectionCountLinkedIn: 69,
        ConnectionCountFacebook: 70,
        ConnectionCountTwitter: 71,
        HiddenChecksum: 72,
        HiddenSpeedDial: 73,
        BiographyFacebook: 74,
        BiographyTwitter: 75,
        BiographyLinkedIn: 76,
        SoundRingtone: 77,
        SimContactType: 78,
        EcoID: 79,
        Personal: 80,
        StockSymbolAll: 81,
        NotificationVibration: 82,
        NotificationLED: 83,
        MessageNotificationVibration: 84,
        MessageNotificationLED: 85,
        MessageNotificationDuringCall: 86,
        VideoChatPin: 87
    };

    subKindAttributeMap[ATTRIBUTE_SUBKIND.Other] = "other";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.Home] = "home";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.Work] = "work";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.PhoneMobile] = "mobile";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.FaxDirect] = "direct";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.Blog] = "blog";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.WebsiteResume] = "resume";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.WebsitePortfolio] = "portfolio";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.WebsitePersonal] = "personal";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.WebsiteCompany] = "company";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.ProfileFacebook] = "facebook";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.ProfileTwitter] = "twitter";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.ProfileLinkedIn] = "linkedin";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.ProfileGist] = "gist";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.ProfileTungle] = "tungle";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.DateBirthday] = "birthday";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.DateAnniversary] = "anniversary";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.NameGiven] = "givenName";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.NameSurname] = "familyName";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.Title] = "honorificPrefix";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.NameSuffix] = "honorificSuffix";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.NameMiddle] = "middleName";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.NamePhoneticGiven] = "phoneticGivenName";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.NamePhoneticSurname] = "phoneticFamilyName";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.NameNickname] = "nickname";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.NameDisplayName] = "displayName";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.OrganizationAffiliationName] = "name";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.OrganizationAffiliationDetails] = "department";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.Title] = "title";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingBbmPin] = "BbmPin";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingAim] = "Aim";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingAliwangwang] = "Aliwangwang";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingGoogleTalk] = "GoogleTalk";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingSametime] = "Sametime";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingIcq] = "Icq";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingJabber] = "Jabber";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingMsLcs] = "MsLcs";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingSkype] = "Skype";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingYahooMessenger] = "YahooMessenger";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.InstantMessagingYahooMessengerJapan] = "YahooMessegerJapan";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.VideoChatBbPlaybook] = "BbPlaybook";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.SoundRingtone] = "ringtone";
    subKindAttributeMap[ATTRIBUTE_SUBKIND.Personal] = "personal";
}

module.exports = {
    getKindAttributeMap: function () {
        if (!ATTRIBUTE_KIND) {
            populateKindAttributeMap();
        }

        return kindAttributeMap;
    },
    getSubKindAttributeMap: function () {
        if (!ATTRIBUTE_SUBKIND) {
            populateSubKindAttributeMap();
        }

        return subKindAttributeMap;
    }
};

});
define('plugin/Contacts/ContactError.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var ContactError = function (code, msg) {
    this.code = code;
    this.message = msg;
};

Object.defineProperty(ContactError, "UNKNOWN_ERROR", { "value": 0 });
Object.defineProperty(ContactError, "INVALID_ARGUMENT_ERROR", { "value": 1 });
Object.defineProperty(ContactError, "TIMEOUT_ERROR", { "value": 2 });
Object.defineProperty(ContactError, "PENDING_OPERATION_ERROR", { "value": 3 });
Object.defineProperty(ContactError, "IO_ERROR", { "value": 4 });
Object.defineProperty(ContactError, "NOT_SUPPORTED_ERROR", { "value": 5 });
Object.defineProperty(ContactError, "PERMISSION_DENIED_ERROR", { "value": 20 });

module.exports = ContactError;


});
define('plugin/Contacts/ContactField.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var ContactField = function (type, value) {
    this.type = type || "";
    this.value = value || "";
};

Object.defineProperty(ContactField, "HOME", {"value": "home"});
Object.defineProperty(ContactField, "WORK", {"value": "work"});
Object.defineProperty(ContactField, "OTHER", {"value": "other"});
Object.defineProperty(ContactField, "MOBILE", {"value": "mobile"});
Object.defineProperty(ContactField, "DIRECT", {"value": "direct"});

module.exports = ContactField;

});
define('plugin/Contacts/ContactFindOptions.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * ContactFindOptions.
 * @constructor
 * @param filter search fields
 * @param sort sort fields and order
 * @param limit max number of contacts to return
 * @param favorite if set, only favorite contacts will be returned
 */

var ContactFindOptions = function (filter, sort, limit, favorite) {
    this.filter = filter || null;
    this.sort = sort || null;
    this.limit = limit || -1; // -1 for returning all results
    this.favorite = favorite || false;
    this.includeAccounts = [];
    this.excludeAccounts = [];
};

Object.defineProperty(ContactFindOptions, "SEARCH_FIELD_GIVEN_NAME", { "value": 0 });
Object.defineProperty(ContactFindOptions, "SEARCH_FIELD_FAMILY_NAME", { "value": 1 });
Object.defineProperty(ContactFindOptions, "SEARCH_FIELD_ORGANIZATION_NAME", { "value": 2 });
Object.defineProperty(ContactFindOptions, "SEARCH_FIELD_PHONE", { "value": 3 });
Object.defineProperty(ContactFindOptions, "SEARCH_FIELD_EMAIL", { "value": 4 });
Object.defineProperty(ContactFindOptions, "SEARCH_FIELD_BBMPIN", { "value": 5 });
Object.defineProperty(ContactFindOptions, "SEARCH_FIELD_LINKEDIN", { "value": 6 });
Object.defineProperty(ContactFindOptions, "SEARCH_FIELD_TWITTER", { "value": 7 });
Object.defineProperty(ContactFindOptions, "SEARCH_FIELD_VIDEO_CHAT", { "value": 8 });

Object.defineProperty(ContactFindOptions, "SORT_FIELD_GIVEN_NAME", { "value": 0 });
Object.defineProperty(ContactFindOptions, "SORT_FIELD_FAMILY_NAME", { "value": 1 });
Object.defineProperty(ContactFindOptions, "SORT_FIELD_ORGANIZATION_NAME", { "value": 2 });

module.exports = ContactFindOptions;


});
define('plugin/Contacts/ContactName.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function toFormattedName(properties) {
    var formatted = "";
    if (properties && properties.givenName) {
        formatted = properties.givenName;
        if (properties && properties.familyName) {
            formatted += " " + properties.familyName;
        }
    }
    return formatted;
}

var ContactName = function (properties) {
    this.familyName = properties && properties.familyName ? properties.familyName : "";
    this.givenName = properties && properties.givenName ? properties.givenName : "";
    this.formatted = toFormattedName(properties);
    this.middleName = properties && properties.middleName ? properties.middleName : "";
    this.honorificPrefix = properties && properties.honorificPrefix ? properties.honorificPrefix : "";
    this.honorificSuffix = properties && properties.honorificSuffix ? properties.honorificSuffix : "";
    this.phoneticFamilyName = properties && properties.phoneticFamilyName ? properties.phoneticFamilyName : "";
    this.phoneticGivenName = properties && properties.phoneticGivenName ? properties.phoneticGivenName : "";
};

module.exports = ContactName;

});
define('plugin/Contacts/ContactNews.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var ContactNews = function (args) {
    this.title = args.title || "";
    this.body = args.body || "";
    this.articleSource = args.articleSource || "";
    this.companies = args.companies || [];
    this.publishedAt = new Date(parseInt(args.publishedAt, 10)) || null;
    this.uri = args.uri || "";
    this.type = args.type || "";
};

module.exports = ContactNews;
});
define('plugin/Contacts/ContactOrganization.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var ContactOrganization = function (properties) {
    this.name = properties && properties.name ? properties.name : "";
    this.department = properties && properties.department ? properties.department : "";
    this.title = properties && properties.title ? properties.title : "";
};

module.exports = ContactOrganization;
});
define('plugin/Contacts/ContactPhoto.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var ContactPhoto = function (originalFilePath, pref) {
    this.originalFilePath = originalFilePath || "";
    this.pref = pref || false;
    this.largeFilePath = "";
    this.smallFilePath = "";
};

module.exports = ContactPhoto;
});
define('plugin/Contacts/contactUtils.js', function (require, exports, module) {
/*
 * Copyright 2012 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
var self,
    ContactFindOptions = require("./ContactFindOptions"),
    ContactError = require("./ContactError"),
    ContactName = require("./ContactName"),
    ContactOrganization = require("./ContactOrganization"),
    ContactAddress = require("./ContactAddress"),
    ContactField = require("./ContactField"),
    contactConsts = require("./contactConsts"),
    ContactPhoto = require("./ContactPhoto"),
    ContactNews = require("./ContactNews"),
    ContactActivity = require("./ContactActivity");

function populateFieldArray(contactProps, field, ClassName) {
    if (contactProps[field]) {
        var list = [],
        obj;

        contactProps[field].forEach(function (args) {
            if (ClassName === ContactField) {
                list.push(new ClassName(args.type, args.value));
            } else if (ClassName === ContactPhoto) {
                obj = new ContactPhoto(args.originalFilePath, args.pref);
                obj.largeFilePath = args.largeFilePath;
                obj.smallFilePath = args.smallFilePath;
                list.push(obj);
            } else if (ClassName === ContactNews) {
                obj = new ContactNews(args);
                list.push(obj);
            } else if (ClassName === ContactActivity) {
                obj = new ContactActivity(args);
                list.push(obj);
            } else {
                list.push(new ClassName(args));
            }
        });
        contactProps[field] = list;
    }
}

function populateDate(contactProps, field) {
    if (contactProps[field]) {
        contactProps[field] = new Date(contactProps[field]);
    }
}

function validateFindArguments(findOptions) {
    var error = false;
    
    // findOptions is mandatory
    if (!findOptions) {
        error = true;
    } else {
        // findOptions.filter is optional
        if (findOptions.filter) {
            findOptions.filter.forEach(function (f) {
                switch (f.fieldName) {
                case ContactFindOptions.SEARCH_FIELD_GIVEN_NAME:
                case ContactFindOptions.SEARCH_FIELD_FAMILY_NAME:
                case ContactFindOptions.SEARCH_FIELD_ORGANIZATION_NAME:
                case ContactFindOptions.SEARCH_FIELD_PHONE:
                case ContactFindOptions.SEARCH_FIELD_EMAIL:
                case ContactFindOptions.SEARCH_FIELD_BBMPIN:
                case ContactFindOptions.SEARCH_FIELD_LINKEDIN:
                case ContactFindOptions.SEARCH_FIELD_TWITTER:
                case ContactFindOptions.SEARCH_FIELD_VIDEO_CHAT:
                    break;
                default:
                    error = true;
                }

                if (!f.fieldValue) {
                    error = true;
                }
            });
        } 

        //findOptions.limit is optional
        if (findOptions.limit) {
            if (typeof findOptions.limit !== "number") {
                error = true;
            } 
        } 

        //findOptions.favorite is optional
        if (findOptions.favorite) {
            if (typeof findOptions.favorite !== "boolean") {
                error = true;
            }
        }

        // findOptions.sort is optional
        if (!error && findOptions.sort && Array.isArray(findOptions.sort)) {
            findOptions.sort.forEach(function (s) {
                switch (s.fieldName) {
                case ContactFindOptions.SORT_FIELD_GIVEN_NAME:
                case ContactFindOptions.SORT_FIELD_FAMILY_NAME:
                case ContactFindOptions.SORT_FIELD_ORGANIZATION_NAME:
                    break;
                default:
                    error = true;
                }

                if (s.desc === undefined || typeof s.desc !== "boolean") {
                    error = true;
                }
            });
        }

        if (!error && findOptions.includeAccounts) {
            if (!Array.isArray(findOptions.includeAccounts)) {
                error = true;
            } else {
                findOptions.includeAccounts.forEach(function (acct) {
                    if (!error && (!acct.id || window.isNaN(window.parseInt(acct.id, 10)))) {
                        error = true;
                    }
                });
            }
        }

        if (!error && findOptions.excludeAccounts) {
            if (!Array.isArray(findOptions.excludeAccounts)) {
                error = true;
            } else {
                findOptions.excludeAccounts.forEach(function (acct) {
                    if (!error && (!acct.id || window.isNaN(window.parseInt(acct.id, 10)))) {
                        error = true;
                    }
                });
            }
        }
    }
    return !error;
}

function validateContactsPickerFilter(filter) {
    var isValid = true,
        availableFields = {};

    if (typeof(filter) === "undefined") {
        isValid = false;
    } else {
        if (filter && Array.isArray(filter)) {
            availableFields = contactConsts.getKindAttributeMap();
            filter.forEach(function (e) {
                isValid = isValid && Object.getOwnPropertyNames(availableFields).reduce(
                    function (found, key) {
                        return found || availableFields[key] === e;
                    }, false);
            });
        }
    }

    return isValid;
}

function validateContactsPickerOptions(options) {
    var isValid = false,
        mode = options.mode;

    if (typeof(options) === "undefined") {
        isValid = false;
    } else {
        isValid = mode === ContactPickerOptions.MODE_SINGLE || mode === ContactPickerOptions.MODE_MULTIPLE || mode === ContactPickerOptions.MODE_ATTRIBUTE;

        // if mode is attribute, fields must be defined
        if (mode === ContactPickerOptions.MODE_ATTRIBUTE && !validateContactsPickerFilter(options.fields)) {
            isValid = false;
        }
    }

    return isValid;
}

self = module.exports = {
    populateContact: function (contact) {
        if (contact.name) {
            contact.name = new ContactName(contact.name);
        }

        populateFieldArray(contact, "addresses", ContactAddress);
        populateFieldArray(contact, "organizations", ContactOrganization);
        populateFieldArray(contact, "emails", ContactField);
        populateFieldArray(contact, "phoneNumbers", ContactField);
        populateFieldArray(contact, "faxNumbers", ContactField);
        populateFieldArray(contact, "pagerNumbers", ContactField);
        populateFieldArray(contact, "ims", ContactField);
        populateFieldArray(contact, "socialNetworks", ContactField);
        populateFieldArray(contact, "urls", ContactField);
        populateFieldArray(contact, "photos", ContactPhoto);
        populateFieldArray(contact, "news", ContactNews);
        populateFieldArray(contact, "activities", ContactActivity);
        // TODO categories

        populateDate(contact, "birthday");
        populateDate(contact, "anniversary");
    },
    invokeErrorCallback: function (errorCallback, code) {
        if (errorCallback) {
            errorCallback(new ContactError(code));
        }
    },
    validateFindArguments: validateFindArguments,
    validateContactsPickerFilter: validateContactsPickerFilter,
    validateContactsPickerOptions: validateContactsPickerOptions
};


});
define('plugin/Device/index.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

function getModelName () {
    var modelName = window.qnx.webplatform.device.modelName;
    //Pre 10.2 (meaning Z10 or Q10)
    if (typeof modelName === "undefined") {
        if (window.screen.height === 720 && window.screen.width === 720) {
            if ( window.matchMedia("(-blackberry-display-technology: -blackberry-display-oled)").matches) {
                modelName = "Q10";
            } else {
                modelName = "Q5";
            }
        } else if ((window.screen.height === 1280 && window.screen.width === 768) ||
                   (window.screen.height === 768 && window.screen.width === 1280)) {
            modelName = "Z10";
        } else {
            modelName = window.qnx.webplatform.deviceName;
        }
    }

    return modelName;
}

function getUUID () {
    var uuid = "";
    try {
        //Must surround by try catch because this will throw if the app is missing permissions
        uuid = window.qnx.webplatform.device.devicePin;
    } catch (e) {
        //DO Nothing
    }
    return uuid;
}

module.exports = {
    getDeviceInfo: function (success, fail, args, env) {
        var result = new PluginResult(args, env),
            modelName = getModelName(),
            uuid = getUUID(),
            info = {
                platform: "blackberry10",
                version: window.qnx.webplatform.device.scmBundle,
                model: modelName,
                uuid: uuid,
                cordova: "dev"
            };
        result.ok(info);
    }
};

});
define('plugin/Logger/index.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

module.exports = {
    logLevel: function (success, fail, args, env) {
        var result = new PluginResult(args, env),
            level = JSON.parse(decodeURIComponent(args[0])),
            message = JSON.parse(decodeURIComponent(args[1]));
        console.log(level + ": " + message);
        result.noResult(false);
    }
};

});
define('plugin/Media/index.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var audioObjects = {},
    mediaErrorsHandled = false;

// There is a bug in the webplatform handling of media error
// dialogs prior to 10.2. This function needs to be run once
// on the webview which plays audio to prevent freezing.
function handleMediaErrors() {
    var webview = qnx.webplatform.getWebViews()[0],
        handler = webview.onDialogRequested;
    if (!mediaErrorsHandled) {
        webview.allowWebEvent("DialogRequested");
        webview.onDialogRequested = undefined;
        webview.onDialogRequested = function (eventArgs) {
            var parsedArgs = JSON.parse(eventArgs);
            if (parsedArgs.dialogType === 'MediaError') {
                return '{"setPreventDefault": true}';
            }
            handler(eventArgs);
        };
        mediaErrorsHandled = true;
    }
}

module.exports = {

    create: function (success, fail, args, env) {
        var result = new PluginResult(args, env),
            id;

        if (!args[0]) {
            result.error("Media Object id was not sent in arguments");
            return;
        }

        id = JSON.parse(decodeURIComponent(args[0]));

        if (!args[1]){
            audioObjects[id] = new Audio();
        } else {
            audioObjects[id] = new Audio(JSON.parse(decodeURIComponent(args[1])));
        }

        handleMediaErrors();

        result.ok();
    },

    startPlayingAudio: function (success, fail, args, env) {

        var audio,
            id,
            result = new PluginResult(args, env);

        if (!args[0]) {
            result.error("Media Object id was not sent in arguments");
            return;
        }

        id = JSON.parse(decodeURIComponent(args[0]));

        audio = audioObjects[id];

        if (!audio) {
            result.error("Audio object has not been initialized");
        } else {
            audio.play();
            result.ok();
        }
    },

    stopPlayingAudio: function (success, fail, args, env) {

        var audio,
            id,
            result = new PluginResult(args, env);

        if (!args[0]) {
            result.error("Media Object id was not sent in arguments");
            return;
        }

        id = JSON.parse(decodeURIComponent(args[0]));

        audio = audioObjects[id];

        if (!audio) {
            result.error("Audio Object has not been initialized");
            return;
        }

        audio.pause();
        audio.currentTime = 0;

        result.ok();
    },

    seekToAudio: function (success, fail, args, env) {

        var audio,
            result = new PluginResult(args, env);

        if (!args[0]) {
            result.error("Media Object id was not sent in arguments");
            return;
        }

        audio = audioObjects[JSON.parse(decodeURIComponent(args[0]))];

        if (!audio) {
            result.error("Audio Object has not been initialized");
        } else if (!args[1]) {
            result.error("Media seek time argument not found");
        } else {
            try {
                audio.currentTime = JSON.parse(decodeURIComponent(args[1])) / 1000;
                result.ok();
            } catch (e) {
                result.error("Error seeking audio: " + e);
            }
        }
    },

    pausePlayingAudio: function (success, fail, args, env) {

        var audio,
            result = new PluginResult(args, env);

        if (!args[0]) {
            result.error("Media Object id was not sent in arguments");
            return;
        }

        audio = audioObjects[JSON.parse(decodeURIComponent(args[0]))];

        if (!audio) {
            result.error("Audio Object has not been initialized");
            return;
        }

        audio.pause();
    },

    getCurrentPositionAudio: function (success, fail, args, env) {

        var audio,
            result = new PluginResult(args, env);

        if (!args[0]) {
            result.error("Media Object id was not sent in arguments");
            return;
        }

        audio = audioObjects[JSON.parse(decodeURIComponent(args[0]))];

        if (!audio) {
            result.error("Audio Object has not been initialized");
            return;
        }

        result.ok(audio.currentTime);
    },

    getDuration: function (success, fail, args, env) {

        var audio,
            result = new PluginResult(args, env);

        if (!args[0]) {
            result.error("Media Object id was not sent in arguments");
            return;
        }

        audio = audioObjects[JSON.parse(decodeURIComponent(args[0]))];

        if (!audio) {
            result.error("Audio Object has not been initialized");
            return;
        }

        result.ok(audio.duration);
    },

    startRecordingAudio: function (success, fail, args, env) {
        var result = new PluginResult(args, env);
        result.error("Not supported");
    },

    stopRecordingAudio: function (success, fail, args, env) {
        var result = new PluginResult(args, env);
        result.error("Not supported");
    },

    release: function (success, fail, args, env) {
        var audio,
            id,
            result = new PluginResult(args, env);

        if (!args[0]) {
            result.error("Media Object id was not sent in arguments");
            return;
        }

        id = JSON.parse(decodeURIComponent(args[0]));

        audio = audioObjects[id];

        if (audio) {
            if(audio.src !== ""){
                audio.src = undefined;
            }
            audioObjects[id] = undefined;
        }

        result.ok();
    }
};

});
define('plugin/NetworkStatus/index.js', function (require, exports, module) {
/*
 * Copyright 2010-2011 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//map from BB10 to cordova connection types:
//https://github.com/apache/cordova-js/blob/master/lib/common/plugin/Connection.js
function mapConnectionType(con) {
    switch (con.type) {
    case 'wired':
        return 'ethernet';
    case 'wifi':
        return 'wifi';
    case 'none':
        return 'none';
    case 'cellular':
        switch (con.technology) {
        case 'edge':
        case 'gsm':
            return '2g';
        case 'evdo':
            return '3g';
        case 'umts':
            return '3g';
        case 'lte':
            return '4g';
        }
        return "cellular";
    }
    return 'unknown';
}

function currentConnectionType() {
    try {
        //possible for webplatform to throw pps exception
        return mapConnectionType(window.qnx.webplatform.device.activeConnection || { type : 'none' });
    }
    catch (e) {
        return 'unknown';
    }
}

module.exports = {
    getConnectionInfo: function (success, fail, args, env) {
        var result = new PluginResult(args, env);
        result.ok(currentConnectionType());
    }
};

});
define('plugin/Notification/index.js', function (require, exports, module) {
/*
* Copyright 2013 Research In Motion Limited.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

function showDialog(args, dialogType, result) {
    //Unpack and map the args
    var msg = JSON.parse(decodeURIComponent(args[0])),
    title = JSON.parse(decodeURIComponent(args[1])),
    btnLabel = JSON.parse(decodeURIComponent(args[2]));

    if (!Array.isArray(btnLabel)) {
        //Converts to array for (string) and (string,string, ...) cases
        btnLabel = btnLabel.split(",");
    }

    if (msg && typeof msg === "string") {
        msg = msg.replace(/^"|"$/g, "").replace(/\\"/g, '"').replace(/\\\\/g, '\\');
    } else {
        result.error("message is undefined");
        return;
    }

    var messageObj = {
        title : title,
        htmlmessage :  msg,
        dialogType : dialogType,
        optionalButtons : btnLabel
    };

    //TODO replace with getOverlayWebview() when available in webplatform
    qnx.webplatform.getWebViews()[2].dialog.show(messageObj, function (data) {
        if (typeof data === "number") {
            //Confirm dialog call back needs to be called with one-based indexing [1,2,3 etc]
            result.callbackOk(++data, false);
        } else {
            //Prompt dialog callback expects object
            result.callbackOk({
                buttonIndex: data.ok ? 1 : 0,
                input1: (data.oktext) ? decodeURIComponent(data.oktext) : ""
            }, false);
        }
    });

    result.noResult(true);
}

module.exports = {
    alert: function (success, fail, args, env) {
        var result = new PluginResult(args, env);

        if (Object.keys(args).length < 3) {
            result.error("Notification action - alert arguments not found.");
        } else {
            showDialog(args, "CustomAsk", result);
        }
    },
    confirm: function (success, fail, args, env) {
        var result = new PluginResult(args, env);

        if (Object.keys(args).length < 3) {
            result.error("Notification action - confirm arguments not found.");
        } else {
            showDialog(args, "CustomAsk", result);
        }
    },
    prompt: function (success, fail, args, env) {
        var result = new PluginResult(args, env);

        if (Object.keys(args).length < 3) {
            result.error("Notification action - prompt arguments not found.");
        } else {
            showDialog(args, "JavaScriptPrompt", result);
        }
    },
    beep: function (success, fail, args, env) {
        var result = new PluginResult(args, env);
        result.error("Beep not supported");
    }
};

});
define('plugin/SplashScreen/index.js', function (require, exports, module) {
/*
 * Copyright 2013 Research In Motion Limited.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

module.exports = {
    show: function (success, fail, args, env) {
        var result = new PluginResult(args, env);
        result.error("Not supported on platform", false);
    },

    hide: function (success, fail, args, env) {
        var result = new PluginResult(args, env);
        window.qnx.webplatform.getApplication().windowVisible = true;
        result.ok(undefined, false);
    }
};

});
}());