/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Shape {
    protected FXVector[] a;
    int[] c;
    int a;
    private int h;
    int b;
    private int i;
    int c;
    long a;
    protected int d;
    protected int e = 1024;
    int f = 4096;
    long b = 0x1000000L;
    long c = 4096L;
    long d = 0x1000000L;
    int g = -1;
    protected UserData a;
    protected FXVector a = new FXVector();
    public static final int MAX_MASS_FX = 0x1000001;

    public static Shape createRectangle(int n, int n2) {
        FXVector[] fXVectorArray = new FXVector[4];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(-(n <<= 12) / 2, -(n2 <<= 12) / 2);
        fXVectorArray2[1] = new FXVector(-n / 2, n2 / 2);
        fXVectorArray2[2] = new FXVector(n / 2, n2 / 2);
        fXVectorArray2[3] = new FXVector(n / 2, -n2 / 2);
        return new Shape(fXVectorArray2);
    }

    public static Shape createCircle(int n) {
        FXVector[] fXVectorArray = new FXVector[1];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(0, n << 12);
        return new Shape(fXVectorArray2);
    }

    public static Shape createRegularPolygon(int n, int n2) {
        FXVector[] fXVectorArray = new FXVector[n2];
        FXVector fXVector = new FXVector(0, n << 12);
        for (int i = 0; i < n2; ++i) {
            FXMatrix fXMatrix = FXMatrix.createRotationMatrix((int)(105414356L * (long)((i << 1) + 1) / (long)(n2 << 1)));
            fXVectorArray[n2 - 1 - i] = fXMatrix.mult(fXVector);
        }
        return new Shape(fXVectorArray);
    }

    public static Shape loadShape(PhysicsFileReader object, UserData userData) {
        int n = ((PhysicsFileReader)object).getVersion();
        if (n <= 512) {
            ((PhysicsFileReader)object).next();
        }
        int n2 = ((PhysicsFileReader)object).next();
        FXVector[] fXVectorArray = new FXVector[n2];
        for (int i = 0; i < n2; ++i) {
            fXVectorArray[i] = ((PhysicsFileReader)object).nextVector();
        }
        Shape shape = new Shape(fXVectorArray);
        shape.setElasticityFX(((PhysicsFileReader)object).nextIntFX());
        shape.setFrictionFX(((PhysicsFileReader)object).nextIntFX());
        if (n >= 1280) {
            shape.setMassFX(((PhysicsFileReader)object).nextIntFX());
        }
        if (((PhysicsFileReader)object).getVersion() > 1536) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                shape.a = userData.createNewUserData((String)object, 2);
            }
        }
        return shape;
    }

    public Shape(FXVector[] fXVectorArray) {
        if (fXVectorArray.length > 12) {
            return;
        }
        this.a = fXVectorArray;
        this.c();
        this.setMass(1);
    }

    public Shape(Shape shape) {
        this.a = new FXVector[shape.a.length];
        System.arraycopy(shape.a, 0, this.a, 0, this.a.length);
        this.setElasticityFX(shape.d);
        this.setFrictionFX(shape.e);
        this.c();
        this.setMassFX(shape.f);
        if (shape.a != null) {
            this.a = shape.a.copy();
        }
    }

    protected Shape() {
    }

    protected final void c() {
        this.a();
        this.h = 0;
        for (int i = 0; i < this.a.length; ++i) {
            FXVector fXVector = this.a[i];
            if (fXVector.lengthSquare() <= this.h * this.h) continue;
            this.h = fXVector.lengthFX() >> 12;
        }
        this.b = this.h << 12;
        this.b();
        Shape shape = this;
        this.i = this.c = shape.b << 1;
        for (int i = 0; i < shape.c.length && shape.c[i] >= 0; i += 2) {
            long l;
            FXVector fXVector = new FXVector(shape.a[shape.c[i]]);
            fXVector.subtract(shape.a[shape.c[i + 1]]);
            fXVector.normalize();
            long l2 = l = (long)shape.a[0].xFX * (long)fXVector.yFX - (long)shape.a[0].yFX * (long)fXVector.xFX >> 12;
            for (int j = 1; j < shape.a.length; ++j) {
                long l3 = (long)shape.a[j].xFX * (long)fXVector.yFX - (long)shape.a[j].yFX * (long)fXVector.xFX >> 12;
                if (l3 < l2) {
                    l2 = l3;
                    continue;
                }
                if (l3 <= l) continue;
                l = l3;
            }
            if ((long)shape.c < l - l2) {
                shape.c = (int)(l - l2);
            }
            if ((long)shape.i <= l - l2) continue;
            shape.i = (int)(l - l2);
        }
    }

    public void correctCentroid() {
        if (this.a.length < 3) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = this.a.length - 1;
        while (n < this.a.length) {
            long l3 = (long)this.a[n].xFX * (long)this.a[n2].yFX - (long)this.a[n].yFX * (long)this.a[n2].xFX >> 12;
            l += l3 * (long)(this.a[n].xFX + this.a[n2].xFX) >> 12;
            l2 += l3 * (long)(this.a[n].yFX + this.a[n2].yFX) >> 12;
            n2 = n++;
        }
        l = (l << 12) / (this.a * 6L);
        l2 = (l2 << 12) / (this.a * 6L);
        for (n = 0; n < this.a.length; ++n) {
            this.a[n].subtract(new FXVector((int)l, (int)l2));
        }
        this.c();
    }

    public FXVector[] getCorners() {
        return this.a;
    }

    public int getBoundingRadiusSquare() {
        return this.h * this.h;
    }

    public int getBoundingRadiusFX() {
        return this.b;
    }

    void a() {
        if (this.a.length == 1) {
            this.c = new int[0];
            this.a = 0;
            return;
        }
        this.c = new int[this.a.length << 1];
        Vector<FXVector> vector = new Vector<FXVector>();
        int n = 0;
        int n2 = this.a.length - 1;
        while (n < this.a.length) {
            FXVector fXVector = new FXVector(this.a[n]);
            fXVector.subtract(this.a[n2]);
            fXVector.normalize();
            boolean bl = true;
            for (int i = 0; i < vector.size(); ++i) {
                FXVector fXVector2 = (FXVector)vector.elementAt(i);
                if (Math.abs((long)fXVector.xFX * (long)fXVector2.xFX + (long)fXVector.yFX * (long)fXVector2.yFX >> 12) <= 4088L) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.c[vector.size() << 1] = n;
                this.c[(vector.size() << 1) + 1] = n2;
                vector.addElement(fXVector);
            }
            n2 = n++;
        }
        this.a = vector.size() << 1;
        for (n = vector.size() << 1; n < this.c.length; ++n) {
            this.c[n] = -1;
        }
    }

    public void setFriction(int n) {
        this.e = (n << 12) / 100;
    }

    public void setFrictionFX(int n) {
        this.e = n;
    }

    public int getFrictionFX() {
        return this.e;
    }

    public void setElasticity(int n) {
        this.d = (n << 12) / 100;
    }

    public void setElasticityFX(int n) {
        this.d = n;
    }

    public int getElasticityFX() {
        return this.d;
    }

    public final void setMass(int n) {
        this.setMassFX(n << 12);
    }

    public final void setMassFX(int n) {
        if (this.a == 0L) {
            this.c = 0x1000001L;
            this.b = 0L;
            this.d = 0L;
            return;
        }
        this.f = n;
        this.b = 0x1000000000L / (long)n;
        this.b();
    }

    public int getMass() {
        return this.f >> 12;
    }

    public int getMassFX() {
        return this.f;
    }

    public int getId() {
        return this.g;
    }

    public long getAreaFX() {
        return this.a;
    }

    void b() {
        this.a = 0L;
        this.c = 0L;
        if (this.a.length == 1) {
            this.a = 52707178L * (long)((int)((long)this.b * (long)this.b) >> 24) >> 12;
            this.c = (int)((long)(this.f / 2) * (long)this.b * (long)this.b >> 24);
        } else if (this.a.length > 2) {
            for (int i = 0; i < this.a.length; ++i) {
                FXVector fXVector = this.a[i];
                FXVector fXVector2 = this.a[i + 1 >= this.a.length ? 0 : i + 1];
                long l = (long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12;
                this.a += l / 2L;
                long l2 = fXVector.xFX;
                long l3 = fXVector.yFX;
                long l4 = fXVector2.xFX;
                long l5 = fXVector2.yFX;
                long l6 = (int)((l2 * l2 + l4 * l2 + l4 * l4) / 12L >> 12);
                long l7 = (int)((l3 * l3 + l5 * l3 + l5 * l5) / 12L >> 12);
                this.c += l * (l6 + l7) >> 12;
            }
            this.c = (this.c << 12) / this.a * (long)this.f >> 12;
        }
        if (this.a > 0L) {
            long l = 0L;
            long l8 = 0L;
            int n = 0;
            int n2 = this.a.length - 1;
            while (n < this.a.length) {
                long l9 = (long)this.a[n].xFX * (long)this.a[n2].yFX - (long)this.a[n].yFX * (long)this.a[n2].xFX >> 12;
                l += l9 * (long)(this.a[n].xFX + this.a[n2].xFX) >> 12;
                l8 += l9 * (long)(this.a[n].yFX + this.a[n2].yFX) >> 12;
                n2 = n++;
            }
            l = (l << 12) / (this.a * 6L);
            l8 = (l8 << 12) / (this.a * 6L);
            this.a.assignFX((int)l, (int)l8);
        } else {
            this.a.assignFX(0, 0);
        }
        this.c += (long)this.f * (long)this.a.lengthSquareFX() >> 12;
        if (this.c == 0L) {
            this.d = Integer.MAX_VALUE;
            return;
        }
        this.d = 0x1000000000L / this.c;
    }

    protected final void a(FXVector fXVector, FXMatrix fXMatrix, FXVector[] fXVectorArray) {
        if (fXVectorArray.length < this.a.length) {
            return;
        }
        for (int i = 0; i < this.a.length; ++i) {
            fXMatrix.mult(this.a[i], fXVectorArray[i]);
            fXVectorArray[i].xFX += fXVector.xFX;
            fXVectorArray[i].yFX += fXVector.yFX;
        }
    }

    public UserData getUserData() {
        return this.a;
    }

    public void setUserData(UserData userData) {
        this.a = userData;
    }
}

