/*
 * Decompiled with CFR 0.152.
 */
package com.thinkink.general;

import com.thinkink.general.AppProperty;
import com.thinkink.general.GeneralFunction;
import com.thinkink.general.ListItemContainer;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ListItem {
    public static int ITEM_HEIGHT = AppProperty.LIST_ITEM_HEIGHT;
    public static Image DEFAULT_PRESSED = GeneralFunction.createImage("list/list_pressed.png");
    Image mIconImage;
    String[] mDescription;
    int mItemXCordi;
    int mItemYCordi;
    int mItemId;
    String mIconImageURL;
    int pointerpressedX;
    int pointerpressedY;
    private boolean mPressedState;
    private Callback mCallback;
    Font f = Font.getFont((int)64, (int)1, (int)8);

    public ListItem(String sourcepath, String smalldesc, int itemId, Callback callback) {
        this.mIconImageURL = sourcepath;
        this.mIconImage = GeneralFunction.createImage(sourcepath);
        this.mDescription = GeneralFunction.drawStringVector(smalldesc, this.f, AppProperty.SCREEN_WIDTH - 70);
        this.mItemId = itemId;
        this.mCallback = callback;
    }

    public void setItemId(int id) {
        this.mItemId = id;
    }

    public String getIconURL() {
        return this.mIconImageURL;
    }

    public int getItemId() {
        return this.mItemId;
    }

    public void setXCordi(int xcordi) {
        this.mItemXCordi = xcordi;
    }

    public int getXCordi() {
        return this.mItemXCordi;
    }

    public void setYCordi(int ycordi) {
        this.mItemYCordi = ycordi;
    }

    public int getYCordi() {
        return this.mItemYCordi;
    }

    public void paint(Graphics g) {
        if (this.mPressedState) {
            g.drawImage(DEFAULT_PRESSED, 0, this.mItemYCordi, 0);
        }
        g.setColor(0xFFFFFF);
        g.drawLine(0, this.mItemYCordi, ListItemContainer.SCREEN_WIDTH, this.mItemYCordi);
        g.drawImage(this.mIconImage, this.mItemXCordi + 10, this.mItemYCordi + (ITEM_HEIGHT - this.mIconImage.getHeight()) / 2, 0);
        g.setColor(0xFFFFFF);
        g.setFont(this.f);
        for (int i = 0; i < this.mDescription.length; ++i) {
            g.drawString(this.mDescription[i], this.mItemXCordi + 40 + 30, this.mItemYCordi + this.f.getHeight() * i + 25, 0);
        }
    }

    public void setIconImage(Image iconimage) {
    }

    public void pointerPressed(int x, int y) {
        if (y > this.mItemYCordi && y < this.mItemYCordi + DEFAULT_PRESSED.getHeight()) {
            this.mPressedState = true;
            this.pointerpressedX = x;
            this.pointerpressedY = y;
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.mPressedState) {
            if (y - this.pointerpressedY == 0) {
                this.mCallback.listItemPressed(this.mItemId);
            }
            this.mPressedState = false;
        }
    }

    public static interface Callback {
        public void listItemPressed(int var1);
    }
}

