/*
 * Decompiled with CFR 0.152.
 */
package com.thinkink.general;

import com.thinkink.general.AppProperty;
import com.thinkink.general.ListItem;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class ListItemContainer {
    public static int SCREEN_WIDTH = AppProperty.SCREEN_WIDTH;
    public static int SCREEN_HEIGHT = AppProperty.SCREEN_HEIGHT;
    static int ITEM_GAP = 0;
    int mXCordi;
    int mCurrentXCordi;
    int mYCordi;
    int mCurrentYCordi;
    int mNoOfListItem;
    Vector mVectorListItem;
    int pointerpressedX;
    int pointerpressedY;
    int pointerReleasedX;
    int pointerReleasedY;
    int pointerDragX;
    int pointerDragY;
    int pointerpressedTime;
    int pointerReleaseTime;
    float speed;
    boolean mSlidingStatus;

    public ListItemContainer(int xcordi, int ycordi) {
        this.mXCordi = xcordi;
        this.mYCordi = ycordi;
        this.mCurrentXCordi = this.mXCordi;
        this.mCurrentYCordi = this.mYCordi;
        this.mVectorListItem = new Vector();
    }

    public void addListItem(ListItem listitem) {
        this.mVectorListItem.addElement(listitem);
        listitem.setYCordi(this.mCurrentYCordi + (ListItem.ITEM_HEIGHT + ITEM_GAP) * this.mNoOfListItem);
        this.mNoOfListItem = this.mVectorListItem.size();
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.mNoOfListItem; ++i) {
            ListItem listItem = (ListItem)this.mVectorListItem.elementAt(i);
            listItem.paint(g);
        }
    }

    public void setYCordi(int ycordi) {
        this.mCurrentYCordi = ycordi;
        for (int i = 0; i < this.mNoOfListItem; ++i) {
            ListItem listItem = (ListItem)this.mVectorListItem.elementAt(i);
            listItem.setYCordi(this.mCurrentYCordi + (ListItem.ITEM_HEIGHT + ITEM_GAP) * listItem.getItemId());
        }
    }

    public int getYCordi() {
        return this.mCurrentYCordi;
    }

    public void pointerPressed(int x, int y) {
        this.mSlidingStatus = false;
        this.pointerpressedX = x;
        this.pointerpressedY = y;
        this.pointerDragX = this.pointerpressedX;
        this.pointerDragY = this.pointerpressedY;
        this.pointerpressedTime = (int)System.currentTimeMillis();
        if (y > this.mYCordi && y < SCREEN_HEIGHT - ListItem.ITEM_HEIGHT) {
            for (int i = 0; i < this.mNoOfListItem; ++i) {
                ListItem listItem = (ListItem)this.mVectorListItem.elementAt(i);
                listItem.pointerPressed(x, y);
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (y > this.mYCordi && y < SCREEN_HEIGHT - ListItem.ITEM_HEIGHT) {
            if (this.pointerDragY < y && this.mCurrentYCordi < this.mYCordi) {
                this.setYCordi(2 * (y - this.pointerDragY) + this.mCurrentYCordi);
                if (this.mCurrentYCordi > this.mYCordi) {
                    this.setYCordi(this.mYCordi);
                }
            }
            if (this.pointerDragY > y && this.mCurrentYCordi + (this.mNoOfListItem + 1) * ListItem.ITEM_HEIGHT - SCREEN_HEIGHT - 20 > 0) {
                this.setYCordi(2 * (y - this.pointerDragY) + this.mCurrentYCordi);
                if (this.mCurrentYCordi + (this.mNoOfListItem + 1) * ListItem.ITEM_HEIGHT - SCREEN_HEIGHT - 20 < 0) {
                    this.setYCordi(this.mYCordi - (this.mNoOfListItem + 1) * ListItem.ITEM_HEIGHT + SCREEN_HEIGHT - 20);
                }
            }
            this.pointerDragY = y;
        }
    }

    public void pointerReleased(int x, int y) {
        this.pointerReleasedX = x;
        this.pointerReleasedY = y;
        this.pointerReleaseTime = (int)System.currentTimeMillis();
        this.speed = (float)(this.pointerReleasedY - this.pointerpressedY) / (float)(this.pointerReleaseTime - this.pointerpressedTime);
        this.mSlidingStatus = true;
        for (int i = 0; i < this.mNoOfListItem; ++i) {
            ListItem listItem = (ListItem)this.mVectorListItem.elementAt(i);
            listItem.pointerReleased(x, y);
        }
    }
}

