/*
 * Decompiled with CFR 0.152.
 */
package com.thinkink.main;

import com.thinkink.general.AppProperty;
import com.thinkink.general.GeneralFunction;
import com.thinkink.general.MainMenu;
import com.thinkink.main.WMidlet;
import com.thinkink.utilities.Button;
import com.thinkink.utilities.SaveImage;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DrawAnimal
extends Canvas
implements Button.CallBack {
    final int BUTTON_BACK;
    final int BUTTON_SAVE;
    final int BUTTON_HOME;
    int mPressedX;
    Image Bstrip = GeneralFunction.createImage("button/button_strip.png");
    Button mBack = new Button(GeneralFunction.createImage("button/back.png"), 183, 363, 3, this);
    Button mSave = new Button(GeneralFunction.createImage("button/save.png"), 103, 363, 2, this);
    Button mHOME = new Button(GeneralFunction.createImage("button/home.png"), 23, 363, 1, this);
    public int mCurrentImageNo = 1;
    public Image mDrawingImage;
    private boolean mDragToTake = false;
    private int mListPosition;

    public DrawAnimal() {
        this.BUTTON_BACK = 3;
        this.BUTTON_SAVE = 2;
        this.BUTTON_HOME = 1;
        this.setFullScreenMode(true);
        this.mDrawingImage = GeneralFunction.createImage("/celebrity/wallpaper/1.jpg");
    }

    public void showNotify() {
        super.showNotify();
        WMidlet.mWMidlet.registerForUP(new WMidlet.CallBack(){

            public void callRepaint(int x, int y, int width, int height) {
                DrawAnimal.this.repaint(x, y, width, height);
            }
        });
        WMidlet.mWMidlet.unRegisterforDown();
    }

    protected void hideNotify() {
        super.hideNotify();
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.drawImage(this.mDrawingImage, 0, 0, 0);
        g.drawImage(this.Bstrip, 0, AppProperty.SCREEN_HEIGHT - this.Bstrip.getHeight(), 0);
        this.mBack.paint(g);
        this.mSave.paint(g);
        this.mHOME.paint(g);
        WMidlet.mWMidlet.paintAd(g);
    }

    public void pointerPressed(int x, int y) {
        this.mPressedX = x;
        this.mBack.pointerPressed(x, y);
        this.mSave.pointerPressed(x, y);
        this.mHOME.pointerPressed(x, y);
        this.mDragToTake = !this.mDragToTake;
        WMidlet.mWMidlet.AdClicked(x, y);
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        if (this.mDragToTake) {
            if (this.mPressedX - x > 10) {
                this.mDragToTake = false;
                ++this.mCurrentImageNo;
                if (this.mCurrentImageNo == AppProperty.IMAGE_LENGHT[this.mListPosition] + 1) {
                    this.mCurrentImageNo = AppProperty.IMAGE_LENGHT[this.mListPosition];
                }
                this.mDrawingImage = GeneralFunction.createImage("/celebrity/wallpaper/" + this.mCurrentImageNo + ".jpg");
                this.mPressedX = x;
                this.repaint();
            } else if (x - this.mPressedX > 10) {
                this.mDragToTake = false;
                --this.mCurrentImageNo;
                if (this.mCurrentImageNo < 1) {
                    this.mCurrentImageNo = 1;
                }
                this.mDrawingImage = GeneralFunction.createImage("/celebrity/wallpaper/" + this.mCurrentImageNo + ".jpg");
                this.repaint();
                this.mPressedX = x;
            }
        }
    }

    public void AreaToRepaint(int xcord, int ycord, int width, int height) {
        this.repaint(xcord, ycord, width, height);
        this.repaint();
    }

    public void ButtonClicked(int buttonid) {
        switch (buttonid) {
            case 3: {
                WMidlet.mDisplay.setCurrent((Displayable)new MainMenu());
                break;
            }
            case 2: {
                if (this.mCurrentImageNo < 0) break;
                this.saveFile("/celebrity/wallpaper/" + this.mCurrentImageNo + ".jpg", this.mCurrentImageNo + ".jpg");
                break;
            }
            case 1: {
                WMidlet.mWMidlet.StartMainMenu();
            }
        }
        this.repaint();
    }

    protected void saveFile(String filepath, String filename) {
        InputStream mimagestream = this.getClass().getResourceAsStream(filepath);
        try {
            byte[] b = new byte[mimagestream.available()];
            mimagestream.read(b);
            new SaveImage().writeToFile(b, "", filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

