/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.nokia.mid.ui.FullCanvas;
import game.Image2;
import game.MultiOutPut;
import game.Pastille;
import game.game;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

class GameScreen
extends FullCanvas
implements Runnable {
    static final byte BG = 4;
    static final byte CURSOR = 2;
    static final byte DANCE_1 = 1;
    static final byte DANCE_2 = 2;
    static final byte DANCE_3 = 3;
    static final byte DANCE_4 = 4;
    static final byte DANCE_BASE = 0;
    static final byte DANCE_COMBO = 5;
    static final byte DANCE_MISS = 6;
    static final byte DEAD = 4;
    static final byte EXPLOSION1 = 6;
    static final byte EXPLOSION2 = 7;
    static final byte EYE_CATCHER = 29;
    static final byte FLAGS = 28;
    static final byte FONT = 3;
    static final byte GAME_OVER = 26;
    static final byte G_CHANGE_LEVEL = 2;
    static final byte G_INIT = 0;
    static final byte G_LOOSE = 4;
    static final byte G_MEGA_COMBO = 5;
    static final byte G_PAUSE = 3;
    static final byte G_PLAYING = 1;
    static final byte INIT = 0;
    static final byte INTERFACE = 13;
    static final byte INTERFACE2 = 14;
    static final byte INTRO = 0;
    static final byte JAUGE = 8;
    static final byte JAUGE_DIFF = 10;
    static final byte JAUGE_MAX = 94;
    static final byte KEY_DOWN = 3;
    static final byte KEY_LEFT = 4;
    static final byte KEY_NUM0 = 6;
    static final byte KEY_NUM1 = 7;
    static final byte KEY_NUM2 = 8;
    static final byte KEY_NUM3 = 9;
    static final byte KEY_NUM4 = 10;
    static final byte KEY_NUM5 = 11;
    static final byte KEY_NUM6 = 12;
    static final byte KEY_NUM7 = 13;
    static final byte KEY_NUM8 = 14;
    static final byte KEY_NUM9 = 15;
    static final byte KEY_OK = 18;
    static final byte KEY_POUND = 17;
    static final byte KEY_RIGHT = 5;
    static final byte KEY_SOFT1 = 0;
    static final byte KEY_SOFT2 = 1;
    static final byte KEY_STAR = 16;
    static final byte KEY_UP = 2;
    static final byte KOZO_0 = 15;
    static final byte KOZO_1 = 16;
    static final byte KOZO_2 = 17;
    static final byte KOZO_3 = 18;
    static final byte KOZO_4 = 19;
    static final byte KOZO_5 = 20;
    static final byte KOZO_6 = 21;
    static final byte KOZO_7 = 22;
    static final byte LEVEL_WON = 25;
    static final byte LOSE = 24;
    static final byte MEGA_COMBO = 23;
    static final byte MEGA_COMBO_BIG = 27;
    static final byte MENU = 1;
    static final byte MESSAGE = 12;
    static final byte MOVE = 1;
    static final byte M_CREDITS = 4;
    static final byte M_ENTER_SCORE = 5;
    static final byte M_HELP = 1;
    static final byte M_LANGUAGE = 6;
    static final byte M_MAIN = 0;
    static final byte M_OPTIONS = 3;
    static final byte M_SCORES = 2;
    static final byte NB_IMG = 30;
    static final byte NB_KEY = 19;
    static final byte NB_PASTILLE = 9;
    static final byte PASTILLE = 5;
    static final byte PUSH = 9;
    static final byte SCORE = 10;
    static final short SCORE_MAX = 400;
    private static final int SCR_H = 208;
    private static final int SCR_W = 176;
    static final byte SHADOW = 11;
    static final byte S_EXIT = 6;
    static final byte S_GAME = 5;
    static final byte S_INTRO = 0;
    static final byte S_LOAD_BEGIN = 1;
    static final byte S_LOAD_GAME = 2;
    static final byte S_LOAD_MENU = 3;
    static final byte S_MENU = 4;
    static final byte XPLODE1 = 2;
    static final byte XPLODE2 = 3;
    static final short ZONE_BOTTOM = 130;
    static final short ZONE_TOP = 110;
    byte _anim;
    int _animCombo;
    boolean _back;
    long _begin;
    int _cptAnim;
    int _cptAnimCombo;
    int _cptAnimComboTime;
    int _cptBg;
    int _cptCombo;
    int _cptCurs;
    int _cptFlags;
    int _cptLetter;
    int _cptLevel;
    int _cptLoad;
    int _cptLoop;
    int _cptMain;
    int _cptMessage;
    int _cptPastille;
    int _cptStumble;
    byte _credit;
    byte _curs;
    Image2 _efusion;
    boolean _enterScore;
    byte _frameDancer;
    int _gameState;
    byte _help;
    int[] _highScores;
    Image2[] _img;
    byte _isMusic;
    byte _jauge;
    byte _key;
    byte[] _keyMap;
    byte[] _kozoLength;
    byte[][] _kozoMoves = new byte[][]{{0, 1, 2, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 7, 6, 5, 4, 3, 2, 1, 0}, {0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0}, {0, 1, 2, 3, 4, 5, 4, 3, 2, 1, 0}, {0, 1, 2, 3, 4, 0, 1, 2, 3, 4, 0}, {0, 1, 2, 3, 4, 5, 4, 3, 2, 1, 0, 1, 2, 3, 4, 5, 4, 3, 2, 1, 0}, {0}};
    byte _language;
    boolean _languageInit = true;
    byte _level = 0;
    byte[] _levelFreq;
    byte[] _levelSpeed;
    int _mainState = 0;
    Image2 _media;
    int _menuState;
    byte _message;
    byte[] _names;
    byte _nbLetter;
    byte _nbMissed;
    boolean _ok;
    boolean _paint;
    Pastille[] _past;
    Random _rand = null;
    int _score;
    byte[] _scorePlus;
    int _scrollX;
    boolean _stumble;
    byte[] _tmpLetter;
    long last_paint = 0L;
    game midlet;
    MultiOutPut mu = null;

    public GameScreen(game game2) {
        this._kozoLength = new byte[]{4, 17, 13, 11, 11, 21, 1};
        this._levelSpeed = new byte[]{2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10};
        this._levelFreq = new byte[]{30, 30, 30, 25, 25, 25, 20, 20, 20, 15, 15, 15};
        this._scorePlus = new byte[]{10, 10, 8, 8, 6, 6, 4, 4, 2, 2, 1, 1};
        this.midlet = game2;
        this.GameInit();
        new Thread(this).start();
    }

    int Abs(int n) {
        int n2 = n >= 0 ? n : 0 - n;
        return n2;
    }

    void Draw_Game(Graphics graphics) {
        graphics.setClip(0, 0, 176, 208);
        graphics.setColor(-1);
        graphics.fillRect(0, 0, 176, 208);
        this._img[29].draw(graphics, 0, 0, 16 + 4);
        this._img[4].drawFrame(graphics, -15, -10, this._cptMain % 4, 16 + 4);
        this._img[4].drawFrame(graphics, 45, 10, this._cptMain % 4, 16 + 4);
        this._img[4].drawFrame(graphics, -12, 50, this._cptMain % 4, 16 + 4);
        this._img[4].drawFrame(graphics, 55, 70, this._cptMain % 4, 16 + 4);
        this._img[4].drawFrame(graphics, 35, 145, this._cptMain % 4, 16 + 4);
        this._img[13].drawFrame(graphics, 91, 0, this._cptMain % 4, 16 + 4);
        this._img[23].drawFrame(graphics, 87, 165, 0, 16 + 4);
        graphics.setClip(82, 178, 94, 30);
        this._img[14].draw(graphics, 82, 178, 16 + 4);
        if (this._message >= 0 && this._cptLevel == 0) {
            this._img[12].drawFrame(graphics, -15, 40, this._message, 16 + 2);
        }
        graphics.setClip(0, 0, 176, 208);
        switch (this._anim) {
            case 0: {
                this._img[11].draw(graphics, 10, 150, 16 + 4);
                this._img[15].drawFrame(graphics, 25, 95, this._frameDancer);
                break;
            }
            case 1: {
                this._img[11].draw(graphics, 10, 150, 16 + 4);
                this._img[16].drawFrame(graphics, 20, 93, this._frameDancer);
                break;
            }
            case 2: {
                this._img[11].draw(graphics, 10, 150, 16 + 4);
                this._img[17].drawFrame(graphics, 16, 70, this._frameDancer);
                break;
            }
            case 3: {
                this._img[11].draw(graphics, 10, 150, 16 + 4);
                this._img[18].drawFrame(graphics, 16, 83, this._frameDancer);
                break;
            }
            case 4: {
                this._img[11].draw(graphics, 10, 150, 16 + 4);
                this._img[19].drawFrame(graphics, 25, 93, this._frameDancer);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this._img[11].draw(graphics, 10, 150, 16 + 4);
                this._img[22].drawFrame(graphics, 15, 100, this._frameDancer);
            }
        }
        graphics.setClip(100, 0, 76, 164);
        int n = 0;
        while (n < 9) {
            if (this._past[n]._state == 0 || this._past[n]._state == 1) {
                this._img[5].drawFrame(graphics, this._past[n]._posX, this._past[n]._posY, this._past[n]._value - 1, 16 + 4);
            } else if (this._past[n]._state == 2) {
                this._img[6].drawFrame(graphics, this._past[n]._posX - 6, this._past[n]._posY - 11, this._past[n]._cptXplode, 16 + 4);
            } else if (this._past[n]._state == 3) {
                this._img[7].drawFrame(graphics, this._past[n]._posX, this._past[n]._posY, this._past[n]._cptXplode, 16 + 4);
            }
            n = (byte)(n + 1);
        }
        graphics.setClip(0, 0, 176, 208);
        if (this._jauge > 0) {
            graphics.setClip(82, 178, 10 + this._jauge, 30);
            if (this._jauge < 84) {
                this._img[8].draw(graphics, 82, 178, 16 + 4);
            } else {
                this._img[9].drawFrame(graphics, 82, 178, this._cptMain % 2, 16 + 4);
            }
        }
        graphics.setClip(0, 0, 176, 208);
        this._img[10].drawFrame(graphics, 2, 2, 0, 16 + 4);
        this.mu.print(graphics, 50, 2, Integer.toString(this._score));
        this.mu.print(graphics, 2, -2, 10, 32 + 4);
        if (this._cptLevel > 0) {
            this.mu.print(graphics, 0, 60, 40, 2);
        }
    }

    void GameExit() {
        int n = 0;
        n = 0;
        while (n < 30) {
            if (this._img[n] != null) {
                this._img[n] = null;
            }
            n = (byte)(n + 1);
        }
        n = 0;
        while (n < 9) {
            if (this._past[n] != null) {
                this._past[n] = null;
            }
            n = (byte)(n + 1);
        }
        this.mu.freeMusic();
        this.mu = null;
    }

    void GameInit() {
        this._rand = new Random();
        this._keyMap = new byte[19];
        this._img = new Image2[30];
        this.mu = new MultiOutPut(176, 208, 1, 1);
        this._past = new Pastille[9];
        int n = 0;
        while (n < 9) {
            this._past[n] = new Pastille(this);
            n = (byte)(n + 1);
        }
        this._highScores = new int[5];
        this._names = new byte[15];
        this._tmpLetter = new byte[3];
        this._begin = System.currentTimeMillis();
        this.Load_Records();
    }

    void Load_Records() {
        try {
            byte[] byArray = new byte[36];
            int n = 0;
            while (n < 5) {
                this._highScores[n] = 50 * (n + 1);
                n = (byte)(n + 1);
            }
            int n2 = 0;
            while (n2 < 15) {
                this._names[n2] = 122;
                n2 = (byte)(n2 + 1);
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"KawaiRecord", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                recordStore.getRecord(1, byArray, 0);
                int n3 = 0;
                while (n3 < 5) {
                    this._highScores[n3] = byArray[n3 * 4] * 1000 + byArray[n3 * 4 + 1] * 100 + byArray[n3 * 4 + 2] * 10 + byArray[n3 * 4 + 3];
                    n3 = (byte)(n3 + 1);
                }
                int n4 = 0;
                while (n4 < 15) {
                    this._names[n4] = byArray[20 + n4];
                    n4 = (byte)(n4 + 1);
                }
                this._isMusic = byArray[35];
            } else {
                recordStore.addRecord(byArray, 0, 36);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    void New_Pastille() {
        int n = -1;
        int n2 = 0;
        while (n2 < 9) {
            if (this._past[n2]._state == 4) {
                n = n2;
                break;
            }
            n2 = (byte)(n2 + 1);
        }
        if (n == -1 || n > 9) {
            return;
        }
        this._past[n]._state = 0;
        this._past[n]._value = (byte)(this.Abs(this._rand.nextInt() % 9) + 1);
        this._past[n]._speed = this._levelSpeed[this._level];
    }

    void Reset_Data() {
        this._key = 0;
        this._jauge = 0;
        this._cptCombo = 0;
        this._cptLevel = 0;
        this._anim = 0;
        this._cptAnim = 0;
        this._cptAnimCombo = 0;
        this._frameDancer = 0;
        this._stumble = false;
        this._message = (byte)-1;
        this._scrollX = 0;
        this._nbMissed = 0;
    }

    void Reset_Direction_Keys() {
        this._keyMap[2] = -1;
        this._keyMap[3] = -1;
        this._keyMap[4] = -1;
        this._keyMap[5] = -1;
        this._keyMap[8] = -1;
        this._keyMap[14] = -1;
        this._keyMap[10] = -1;
        this._keyMap[12] = -1;
    }

    void Save_Records() {
        byte[] byArray = new byte[36];
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"KawaiRecord", (boolean)false);
            if (recordStore.getNumRecords() > 0) {
                int n;
                int n2 = 0;
                while (n2 < 5) {
                    n = (byte)(this._highScores[n2] / 1000);
                    byte by = (byte)((this._highScores[n2] - 1000 * n) / 100);
                    byte by2 = (byte)((this._highScores[n2] - 1000 * n - 100 * by) / 10);
                    byte by3 = (byte)(this._highScores[n2] % 10);
                    byArray[n2 * 4] = n;
                    byArray[n2 * 4 + 1] = by;
                    byArray[n2 * 4 + 2] = by2;
                    byArray[n2 * 4 + 3] = by3;
                    n2 = (byte)(n2 + 1);
                }
                n = 0;
                while (n < 15) {
                    byArray[20 + n] = this._names[n];
                    n = (byte)(n + 1);
                }
                byArray[35] = this._isMusic;
                recordStore.setRecord(1, byArray, 0, 36);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    void Update_Game(Graphics graphics) {
        this.keyUpdate();
        block0 : switch (this._gameState) {
            case 0: {
                this._gameState = 1;
                this._level = 0;
                this._score = 0;
                this._enterScore = false;
                int n = 0;
                while (n < 9) {
                    this._past[n]._state = (byte)4;
                    n = (byte)(n + 1);
                }
                this.Reset_Data();
                if (this._isMusic == 0) {
                    this.mu.startMusic(0);
                }
            }
            case 1: {
                int n;
                if (this._keyMap[0] > 0) {
                    this._keyMap[0] = -1;
                    this._gameState = 3;
                    this._curs = 0;
                    this.mu.stopMusic(0);
                    return;
                }
                if (this._nbMissed >= 15) {
                    this._gameState = 4;
                    this._curs = 0;
                    return;
                }
                if (this._jauge >= 84 && this._keyMap[6] > 0) {
                    this._keyMap[6] = -1;
                    this._jauge = 0;
                    this._anim = (byte)5;
                    this._cptAnim = 0;
                    this._cptLoop = 0;
                    this._cptCombo = 1;
                    this._stumble = false;
                    this._message = (byte)this.Abs(this._rand.nextInt() % 5);
                    this._cptMessage = 0;
                    this._animCombo = this.Abs(this._rand.nextInt() % 2);
                    this._cptAnimComboTime = this._cptMain;
                    this._cptAnimCombo = 0;
                    n = 0;
                    while (n < 9) {
                        if (this._past[n] != null && this._past[n]._state == 1) {
                            this._score += this._scorePlus[this._level];
                            this._past[n]._state = (byte)2;
                            this._past[n]._cptXplode = 0;
                        }
                        n = (byte)(n + 1);
                    }
                    this._gameState = 5;
                }
                if (this._score >= 400 * (this._level + 1) && this._cptLevel == 0) {
                    this._cptLevel = 1;
                    n = 0;
                    while (n < 9) {
                        if (this._past[n] != null && this._past[n]._state == 1) {
                            this._past[n]._state = (byte)2;
                            this._past[n]._cptXplode = 0;
                        }
                        n = (byte)(n + 1);
                    }
                }
                if (this._cptPastille % this._levelFreq[this._level] == 0 && this._cptCombo == 0 && this._cptLevel == 0) {
                    this.New_Pastille();
                }
                n = 0;
                while (n < 9) {
                    this._past[n].Update();
                    n = (byte)(n + 1);
                }
                if (this._key > 0) {
                    int n2 = 0;
                    while (n2 < 9) {
                        if (this._past[n2]._state == 1 && this._past[n2]._value == this._key && this._past[n2]._posY >= 110 && this._past[n2]._posY <= 130) {
                            this._past[n2]._state = (byte)2;
                            this._past[n2]._cptXplode = 0;
                            this._score += this._scorePlus[this._level];
                            this._message = (byte)this.Abs(this._rand.nextInt() % 5);
                            this._cptMessage = 0;
                            if (this._jauge < 84) {
                                this._jauge = (byte)(this._jauge + 6);
                            }
                            if (this._anim == 0) {
                                this._anim = (byte)(1 + this.Abs(this._rand.nextInt() % 4));
                                this._cptAnim = 0;
                            }
                        }
                        n2 = (byte)(n2 + 1);
                    }
                    this._key = 0;
                }
                if (this._anim != 5) {
                    this._frameDancer = this._kozoMoves[this._anim][this._cptAnim];
                    if (this._cptMain % 3 == 0) {
                        ++this._cptAnim;
                    }
                    if (this._cptAnim >= this._kozoLength[this._anim]) {
                        this._anim = 0;
                        this._cptAnim = 0;
                    }
                }
                if (this._stumble) {
                    this._frameDancer = this._kozoMoves[6][0];
                    ++this._cptStumble;
                    this._message = (byte)5;
                    this._anim = (byte)6;
                    this._cptAnim = 0;
                    if (this._cptStumble > 3) {
                        this._stumble = false;
                        this._cptAnim = 0;
                        this._anim = 0;
                    }
                }
                this.Draw_Game(graphics);
                ++this._cptPastille;
                if (this._cptCombo > 0) {
                    ++this._cptCombo;
                    if (this._cptCombo > 10) {
                        this._cptCombo = 0;
                    }
                }
                if (this._cptLevel > 0) {
                    ++this._cptLevel;
                    if (this._cptLevel > 25) {
                        this._cptLevel = 0;
                        this._gameState = 2;
                        this.mu.stopMusic(0);
                    }
                }
                if (this._message < 0) break;
                ++this._cptMessage;
                if (this._cptMessage <= 10 || this._anim == 5) break;
                this._message = (byte)-1;
                break;
            }
            case 3: {
                this._img[1].draw(graphics, 0, 0, 16 + 4);
                this.mu.print(graphics, 0, 80, 10, 2);
                this.mu.print(graphics, 0, 110, 11, 2);
                this.mu.print(graphics, 0, 130, 12, 2);
                this.mu.print(graphics, 0, 150, 18, 2);
                if (this._curs == 2) {
                    this.mu.print(graphics, 2, -2, 21, 32 + 4);
                } else {
                    this.mu.print(graphics, 2, -2, 39, 32 + 4);
                }
                if (this._isMusic == 0) {
                    this.mu.print(graphics, 20, 160, 19, 2);
                } else {
                    this.mu.print(graphics, 20, 160, 20, 2);
                }
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                    this._keyMap[2] = -1;
                    this._keyMap[8] = -1;
                    this._curs = (byte)(this._curs - 1);
                    if (this._curs < 0) {
                        this._curs = (byte)2;
                    }
                } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this._keyMap[3] = -1;
                    this._keyMap[14] = -1;
                    this._curs = (byte)(this._curs + 1);
                    if (this._curs > 2) {
                        this._curs = 0;
                    }
                }
                if (this._curs == 2) {
                    this._img[2].drawFrame(graphics, 88 - this.mu.getStrTradLength(this._curs + 16) * this.mu.iCharSizeX / 2 - 29, 110 + 20 * this._curs, this._cptCurs);
                } else {
                    this._img[2].drawFrame(graphics, 88 - this.mu.getStrTradLength(this._curs + 11) * this.mu.iCharSizeX / 2 - 29, 110 + 20 * this._curs, this._cptCurs);
                }
                ++this._cptCurs;
                if (this._cptCurs > 8) {
                    this._cptCurs = 0;
                }
                if (this._keyMap[11] <= 0 && this._keyMap[18] <= 0 && this._keyMap[0] <= 0) break;
                this._keyMap[11] = -1;
                this._keyMap[18] = -1;
                this._keyMap[0] = -1;
                if (this._curs == 0) {
                    this._gameState = 1;
                    if (this._isMusic != 0) break;
                    this.mu.startMusic(0);
                    break;
                }
                if (this._curs == 1) {
                    this._mainState = 3;
                    this._cptLoad = 0;
                    this.mu.freeMusic();
                    int n = 0;
                    while (n < 5) {
                        if (this._score > this._highScores[n]) {
                            this._enterScore = true;
                            break block0;
                        }
                        n = (byte)(n + 1);
                    }
                    break;
                }
                this._isMusic = (byte)(1 - this._isMusic);
                break;
            }
            case 4: {
                this._img[24].draw(graphics, 0, 0, 16 + 4);
                this._img[26].draw(graphics, 15, 10, 16 + 4);
                this.mu.print(graphics, 2, -2, 39, 32 + 4);
                if (this._keyMap[11] <= 0 && this._keyMap[18] <= 0 && this._keyMap[0] <= 0) break;
                this._keyMap[11] = -1;
                this._keyMap[18] = -1;
                this._keyMap[0] = -1;
                this._mainState = 3;
                this._cptLoad = 0;
                this.mu.stopMusic(0);
                this.mu.freeMusic();
                int n = 0;
                while (n < 5) {
                    if (this._score > this._highScores[n]) {
                        this._enterScore = true;
                        break block0;
                    }
                    n = (byte)(n + 1);
                }
                break;
            }
            case 2: {
                ++this._cptLevel;
                if (this._cptLevel == 1) {
                    this._img[25].draw(graphics, 0, 0, 16 + 4);
                    this.mu.print(graphics, -20, 40, 6, 8);
                    this.mu.print(graphics, -20, 60, 7, 8);
                    this.mu.print(graphics, -20, 80, 8, 8);
                    break;
                }
                if (this._cptLevel == 2) {
                    this._level = (byte)(this._level + 1);
                    if (this._level > 11) {
                        this._level = 0;
                    }
                    if (this._img[4] != null) {
                        this._img[4] = null;
                    }
                    this.mu.freeMusic();
                    System.gc();
                    break;
                }
                if (this._cptLevel == 3) {
                    switch (this._level) {
                        case 0: 
                        case 4: 
                        case 8: {
                            this._img[4] = new Image2("/gfx/bg_a.png", 4, 1, true);
                            this.mu.loadMidiWaveFile("/level/1_bis.mid", true, true, 0);
                            break;
                        }
                        case 1: 
                        case 5: 
                        case 9: {
                            this._img[4] = new Image2("/gfx/bg_b.png", 4, 1, true);
                            this.mu.loadMidiWaveFile("/level/2.mid", true, true, 0);
                            break;
                        }
                        case 2: 
                        case 6: 
                        case 10: {
                            this._img[4] = new Image2("/gfx/bg_c.png", 4, 1, true);
                            this.mu.loadMidiWaveFile("/level/3.mid", true, true, 0);
                            break;
                        }
                        case 3: 
                        case 7: 
                        case 11: {
                            this._img[4] = new Image2("/gfx/bg_d.png", 4, 1, true);
                            this.mu.loadMidiWaveFile("/level/4.mid", true, true, 0);
                        }
                    }
                    System.gc();
                    break;
                }
                if (this._cptLevel != 4) break;
                this._cptLevel = 0;
                this.Reset_Data();
                this._gameState = 1;
                if (this._isMusic != 0) break;
                this.mu.startMusic(0);
                break;
            }
            case 5: {
                if (this._cptMain < this._cptAnimComboTime + (this._kozoLength[this._anim] * 3 - 2)) {
                    graphics.setClip(0, 0, 176, 208);
                    graphics.setColor(-1);
                    graphics.fillRect(0, 0, 176, 208);
                    if (this._animCombo == 0) {
                        this._img[27].drawFrame(graphics, 23, 25, this._cptMain % 3, 16 + 4);
                        this._img[20].drawFrame(graphics, 0, -20, this._kozoMoves[this._anim][this._cptAnimCombo], 2 + 32);
                    } else {
                        this._img[27].drawFrame(graphics, 23, 10, this._cptMain % 3, 16 + 4);
                        this._img[21].drawFrame(graphics, 0, -20, this._kozoMoves[this._anim][this._cptAnimCombo], 2 + 32);
                    }
                    if (this._cptMain % 3 != 0) break;
                    ++this._cptAnimCombo;
                    break;
                }
                this._anim = 0;
                this._gameState = 1;
                this._cptAnim = 0;
            }
        }
    }

    void Update_Menu(Graphics graphics) {
        this.keyUpdate();
        this._img[1].draw(graphics, 0, 0, 16 + 4);
        this._ok = false;
        this._back = false;
        if (this._keyMap[0] > 0 || this._keyMap[11] > 0 || this._keyMap[18] > 0) {
            this._keyMap[0] = -1;
            this._keyMap[11] = -1;
            this._keyMap[18] = -1;
            this._ok = true;
        } else if (this._keyMap[1] > 0) {
            this._keyMap[1] = -1;
            this._back = true;
        }
        switch (this._menuState) {
            case 0: {
                this.mu.print(graphics, 2, -2, 39, 32 + 4);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                    this._keyMap[2] = -1;
                    this._keyMap[8] = -1;
                    this._curs = (byte)(this._curs - 1);
                    if (this._curs < 0) {
                        this._curs = (byte)5;
                    }
                } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this._keyMap[3] = -1;
                    this._keyMap[14] = -1;
                    this._curs = (byte)(this._curs + 1);
                    if (this._curs > 5) {
                        this._curs = 0;
                    }
                }
                int n = 0;
                while (n < 6) {
                    this.mu.print(graphics, 0, 73 + 20 * n, n, 2);
                    n = (byte)(n + 1);
                }
                switch (this._curs) {
                    case 0: {
                        if (!this._ok) break;
                        this._mainState = 2;
                        this._cptLoad = 0;
                        break;
                    }
                    case 1: {
                        if (!this._ok) break;
                        this._menuState = 1;
                        this._help = 0;
                        break;
                    }
                    case 2: {
                        if (!this._ok) break;
                        this._menuState = 2;
                        break;
                    }
                    case 3: {
                        if (!this._ok) break;
                        this._menuState = 3;
                        this._curs = 0;
                        break;
                    }
                    case 4: {
                        if (!this._ok) break;
                        this._menuState = 4;
                        this._credit = 0;
                        break;
                    }
                    case 5: {
                        if (!this._ok) break;
                        this._mainState = 6;
                    }
                }
                this._img[2].drawFrame(graphics, 88 - this.mu.getStrTradLength(this._curs) * this.mu.iCharSizeX / 2 - 29, 73 + 20 * this._curs, this._cptCurs);
                break;
            }
            case 1: {
                this.mu.print(graphics, -2, -2, 9, 32 + 8);
                if (this._help == 0) {
                    int n = 0;
                    while (n < 5) {
                        this.mu.print(graphics, 0, 80 + 20 * n, n + 24, 2);
                        n = (byte)(n + 1);
                    }
                    this.mu.print(graphics, 2, -2, 41, 32 + 4);
                } else if (this._help == 1) {
                    int n = 0;
                    while (n < 5) {
                        this.mu.print(graphics, 0, 80 + 20 * n, n + 29, 2);
                        n = (byte)(n + 1);
                    }
                    this.mu.print(graphics, 2, -2, 41, 32 + 4);
                } else if (this._help == 2) {
                    int n = 0;
                    while (n < 5) {
                        this.mu.print(graphics, 0, 80 + 20 * n, n + 49, 2);
                        n = (byte)(n + 1);
                    }
                    this.mu.print(graphics, 2, -2, 41, 32 + 4);
                } else {
                    int n = 0;
                    while (n < 5) {
                        this.mu.print(graphics, 0, 80 + 20 * n, n + 54, 2);
                        n = (byte)(n + 1);
                    }
                }
                if (this._ok && this._help < 3) {
                    this._help = (byte)(this._help + 1);
                    break;
                }
                if (!this._back && (!this._ok || this._help != 3)) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 2: {
                this.mu.print(graphics, -2, -2, 9, 32 + 8);
                int n = 0;
                while (n < 5) {
                    this.mu.printValue(graphics, 120, 160 - 20 * n, this._highScores[n]);
                    n = (byte)(n + 1);
                }
                int n2 = 0;
                while (n2 < 5) {
                    this._img[3].drawFrame(graphics, 40, 160 - 20 * n2, this._names[n2 * 3] - 97);
                    this._img[3].drawFrame(graphics, 50, 160 - 20 * n2, this._names[n2 * 3 + 1] - 97);
                    this._img[3].drawFrame(graphics, 60, 160 - 20 * n2, this._names[n2 * 3 + 2] - 97);
                    n2 = (byte)(n2 + 1);
                }
                if (!this._ok && !this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 3: {
                this.mu.print(graphics, -2, -2, 9, 32 + 8);
                this.mu.print(graphics, 0, 80, 18, 2);
                if (this._curs == 0) {
                    this.mu.print(graphics, 2, -2, 21, 32 + 4);
                } else {
                    this.mu.print(graphics, 2, -2, 39, 32 + 4);
                }
                if (this._isMusic == 0) {
                    this.mu.print(graphics, 0, 100, 19, 2);
                } else {
                    this.mu.print(graphics, 0, 100, 20, 2);
                }
                this.mu.print(graphics, 0, 120, 42, 2);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0 || this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(1 - this._curs);
                }
                this._img[2].drawFrame(graphics, 88 - this.mu.getStrTradLength(18 + this._curs * 24) * this.mu.iCharSizeX / 2 - 29, 80 + 40 * this._curs, this._cptCurs);
                if (this._ok) {
                    if (this._curs == 0) {
                        this._isMusic = (byte)(1 - this._isMusic);
                        if (this._isMusic == 0) {
                            this.mu.startMusic(0);
                            break;
                        }
                        this.mu.stopMusic(0);
                        break;
                    }
                    this._language = 0;
                    this._menuState = 6;
                    break;
                }
                if (!this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 6: {
                if (!this._languageInit) {
                    this.mu.print(graphics, -2, -2, 9, 32 + 8);
                }
                this.mu.print(graphics, 2, -2, 39, 32 + 4);
                this._cptFlags = 0;
                while (this._cptFlags < 6) {
                    if (this._cptFlags < 3) {
                        if (this._cptFlags != this._language) {
                            this._img[28].drawFrame(graphics, 37, 70 + 43 * this._cptFlags, 1 + this._cptFlags * 2);
                        } else {
                            this._img[28].drawFrame(graphics, 37, 70 + 43 * this._cptFlags, this._cptFlags * 2);
                        }
                    } else if (this._cptFlags != this._language) {
                        this._img[28].drawFrame(graphics, 119, 70 + 43 * (this._cptFlags - 3), 1 + this._cptFlags * 2);
                    } else {
                        this._img[28].drawFrame(graphics, 119, 70 + 43 * (this._cptFlags - 3), this._cptFlags * 2);
                    }
                    ++this._cptFlags;
                }
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                    this._keyMap[2] = -1;
                    this._keyMap[8] = -1;
                    this._language = (byte)(this._language - 1);
                    if (this._language < 0) {
                        this._language = (byte)5;
                    }
                } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this._keyMap[3] = -1;
                    this._keyMap[14] = -1;
                    this._language = (byte)(this._language + 1);
                    if (this._language > 5) {
                        this._language = 0;
                    }
                } else if (this._keyMap[5] > 0 || this._keyMap[12] > 0) {
                    this._keyMap[5] = -1;
                    this._keyMap[12] = -1;
                    this._language = (byte)(this._language + 3);
                    if (this._language > 5) {
                        this._language = (byte)(this._language - 3);
                    }
                } else if (this._keyMap[4] > 0 || this._keyMap[10] > 0) {
                    this._keyMap[4] = -1;
                    this._keyMap[10] = -1;
                    this._language = (byte)(this._language - 3);
                    if (this._language < 0) {
                        this._language = (byte)(this._language + 3);
                    }
                }
                if (this._language < 3) {
                    this._img[2].drawFrame(graphics, 13, 78 + 43 * this._language, this._cptCurs);
                } else {
                    this._img[2].drawFrame(graphics, 95, 78 + 43 * (this._language - 3), this._cptCurs);
                }
                if (this._ok) {
                    switch (this._language) {
                        case 0: {
                            game.sLang = "fr";
                            break;
                        }
                        case 1: {
                            game.sLang = "de";
                            break;
                        }
                        case 2: {
                            game.sLang = "en";
                            break;
                        }
                        case 3: {
                            game.sLang = "es";
                            break;
                        }
                        case 4: {
                            game.sLang = "it";
                            break;
                        }
                        case 5: {
                            game.sLang = "pt";
                        }
                    }
                    this.mu.stopMusic(0);
                    this.mu.freeMusic();
                    this.mu = null;
                    System.gc();
                    this.mu = new MultiOutPut(176, 208, 1, 1);
                    this.mu.loadMidiWaveFile("/level/5.mid", true, true, 0);
                    if (this._isMusic == 0) {
                        this.mu.startMusic(0);
                    }
                    this._menuState = 0;
                    this._curs = 0;
                    this._languageInit = false;
                }
                if (this._languageInit || !this._back) break;
                this._menuState = 0;
                this._curs = 0;
                this._languageInit = false;
                break;
            }
            case 4: {
                this.mu.print(graphics, -2, -2, 9, 32 + 8);
                if (this._credit == 0) {
                    int n = 0;
                    while (n < 5) {
                        this.mu.print(graphics, 0, 80 + 20 * n, 13 + n, 2);
                        n = (byte)(n + 1);
                    }
                    this.mu.print(graphics, 2, -2, 41, 32 + 4);
                } else if (this._credit == 1) {
                    int n = 0;
                    while (n < 4) {
                        this.mu.print(graphics, 0, 80 + 20 * n, 35 + n, 2);
                        n = (byte)(n + 1);
                    }
                }
                if (this._keyMap[8] > 0 || this._keyMap[14] > 0 || this._keyMap[2] > 0 || this._keyMap[3] > 0) {
                    this.Reset_Direction_Keys();
                    this._credit = (byte)(1 - this._credit);
                }
                if (this._ok && this._credit == 0) {
                    this._credit = 1;
                    break;
                }
                if (!this._back && (!this._ok || this._credit != 1)) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 5: {
                ++this._cptLetter;
                this.mu.print(graphics, 0, 75, 22, 2);
                this.mu.print(graphics, 0, 95, 23, 2);
                this.mu.print(graphics, 2, -2, 39, 32 + 4);
                if (this._keyMap[14] > 0 || this._keyMap[3] > 0) {
                    this._keyMap[14] = -1;
                    this._keyMap[3] = -1;
                    byte by = this._nbLetter;
                    this._tmpLetter[by] = (byte)(this._tmpLetter[by] + 1);
                    if (this._tmpLetter[this._nbLetter] > 25) {
                        this._tmpLetter[this._nbLetter] = 0;
                    }
                } else if (this._keyMap[8] > 0 || this._keyMap[2] > 0) {
                    this._keyMap[8] = -1;
                    this._keyMap[2] = -1;
                    byte by = this._nbLetter;
                    this._tmpLetter[by] = (byte)(this._tmpLetter[by] - 1);
                    if (this._tmpLetter[this._nbLetter] < 0) {
                        this._tmpLetter[this._nbLetter] = 25;
                    }
                } else if (this._ok) {
                    this._ok = false;
                    if (this._nbLetter < 2) {
                        this._nbLetter = (byte)(this._nbLetter + 1);
                    } else {
                        int n = 0;
                        int n3 = 0;
                        n3 = 0;
                        while (n3 < 5) {
                            if (this._score >= this._highScores[n3]) {
                                n = n3;
                            }
                            n3 = (byte)(n3 + 1);
                        }
                        if (n > 0) {
                            n3 = 0;
                            while (n3 < n) {
                                this._highScores[n3] = this._highScores[n3 + 1];
                                this._names[n3 * 3] = this._names[n3 * 3 + 3];
                                this._names[n3 * 3 + 1] = this._names[n3 * 3 + 4];
                                this._names[n3 * 3 + 2] = this._names[n3 * 3 + 5];
                                n3 = (byte)(n3 + 1);
                            }
                        }
                        this._highScores[n] = this._score;
                        this._names[n * 3] = (byte)(this._tmpLetter[0] + 97);
                        this._names[n * 3 + 1] = (byte)(this._tmpLetter[1] + 97);
                        this._names[n * 3 + 2] = (byte)(this._tmpLetter[2] + 97);
                        this._menuState = 2;
                        this.Save_Records();
                    }
                }
                if (this._nbLetter == 0) {
                    if (this._cptLetter % 10 < 5) {
                        this._img[3].drawFrame(graphics, 65, 130, this._tmpLetter[0]);
                    }
                } else if (this._nbLetter == 1) {
                    this._img[3].drawFrame(graphics, 65, 130, this._tmpLetter[0]);
                    if (this._cptLetter % 10 < 5) {
                        this._img[3].drawFrame(graphics, 79, 130, this._tmpLetter[1]);
                    }
                } else {
                    this._img[3].drawFrame(graphics, 65, 130, this._tmpLetter[0]);
                    this._img[3].drawFrame(graphics, 79, 130, this._tmpLetter[1]);
                    if (this._cptLetter % 10 < 5) {
                        this._img[3].drawFrame(graphics, 93, 130, this._tmpLetter[2]);
                    }
                }
                ++this._cptLetter;
            }
        }
        ++this._cptCurs;
        if (this._cptCurs > 8) {
            this._cptCurs = 0;
        }
    }

    protected void hideNotify() {
        this.Save_Records();
        this.GameExit();
        System.gc();
        this.midlet.destroyApp(false);
    }

    protected void keyPressed(int n) {
        switch (n) {
            case -6: {
                this._keyMap[0] = 1;
                break;
            }
            case -7: {
                this._keyMap[1] = 1;
                break;
            }
            case -5: {
                this._keyMap[18] = 1;
                break;
            }
            case -1: {
                this._keyMap[2] = 1;
                break;
            }
            case -2: {
                this._keyMap[3] = 1;
                break;
            }
            case -3: {
                this._keyMap[4] = 1;
                break;
            }
            case -4: {
                this._keyMap[5] = 1;
                break;
            }
            case 48: {
                this._keyMap[6] = 1;
                break;
            }
            case 49: {
                this._keyMap[7] = 1;
                break;
            }
            case 50: {
                this._keyMap[8] = 1;
                break;
            }
            case 51: {
                this._keyMap[9] = 1;
                break;
            }
            case 52: {
                this._keyMap[10] = 1;
                break;
            }
            case 53: {
                this._keyMap[11] = 1;
                break;
            }
            case 54: {
                this._keyMap[12] = 1;
                break;
            }
            case 55: {
                this._keyMap[13] = 1;
                break;
            }
            case 56: {
                this._keyMap[14] = 1;
                break;
            }
            case 57: {
                this._keyMap[15] = 1;
                break;
            }
            case 42: {
                this._keyMap[16] = 1;
                break;
            }
            case 35: {
                this._keyMap[17] = 1;
            }
        }
    }

    protected void keyReleased(int n) {
        switch (n) {
            case -6: {
                this._keyMap[0] = -1;
                break;
            }
            case -7: {
                this._keyMap[1] = -1;
                break;
            }
            case -5: {
                this._keyMap[18] = -1;
                break;
            }
            case -1: {
                this._keyMap[2] = -1;
                break;
            }
            case -2: {
                this._keyMap[3] = -1;
                break;
            }
            case -3: {
                this._keyMap[4] = -1;
                break;
            }
            case -4: {
                this._keyMap[5] = -1;
                break;
            }
            case 48: {
                this._keyMap[6] = -1;
                break;
            }
            case 49: {
                this._keyMap[7] = -1;
                break;
            }
            case 50: {
                this._keyMap[8] = -1;
                break;
            }
            case 51: {
                this._keyMap[9] = -1;
                break;
            }
            case 52: {
                this._keyMap[10] = -1;
                break;
            }
            case 53: {
                this._keyMap[11] = -1;
                break;
            }
            case 54: {
                this._keyMap[12] = -1;
                break;
            }
            case 55: {
                this._keyMap[13] = -1;
                break;
            }
            case 56: {
                this._keyMap[14] = -1;
                break;
            }
            case 57: {
                this._keyMap[15] = -1;
                break;
            }
            case 42: {
                this._keyMap[16] = -1;
                break;
            }
            case 35: {
                this._keyMap[17] = -1;
            }
        }
    }

    void keyUpdate() {
        int n = 0;
        n = 0;
        while (n < 19) {
            if (this._keyMap[n] > 0 && this._keyMap[n] < 20) {
                int n2 = n;
                this._keyMap[n2] = (byte)(this._keyMap[n2] + 1);
            } else if (this._keyMap[n] == -1) {
                this._keyMap[n] = -2;
            } else if (this._keyMap[n] == -2) {
                this._keyMap[n] = 0;
            }
            n = (byte)(n + 1);
        }
        n = 7;
        while (n <= 15) {
            if (this._keyMap[n] > 0 && this._keyMap[n] < 3) {
                this._key = (byte)(n - 6);
            }
            n = (byte)(n + 1);
        }
    }

    public void paint(Graphics graphics) {
        if (this._paint) {
            return;
        }
        this._paint = true;
        switch (this._mainState) {
            case 0: {
                graphics.setClip(0, 0, 176, 208);
                graphics.setColor(-1);
                graphics.fillRect(0, 0, 176, 208);
                if (this._media == null) {
                    this._media = new Image2("/gfx/mediaplazza.png", 1, 1, true);
                }
                if (this._efusion == null) {
                    this._efusion = new Image2("/gfx/efusion.png", 1, 1, true);
                }
                if (System.currentTimeMillis() - this._begin < 2500L) {
                    this._media.draw(graphics, 176 - this._media.dx >> 1, 208 - this._media.dy >> 1);
                    break;
                }
                if (System.currentTimeMillis() - this._begin < 5000L) {
                    this._efusion.draw(graphics, 176 - this._efusion.dx >> 1, 208 - this._efusion.dy >> 1);
                    break;
                }
                this._mainState = 1;
                this._cptLoad = 0;
                break;
            }
            case 1: {
                if (this._cptLoad == 0) {
                    this._cptLoad = 1;
                    if (this._media != null) {
                        this._media = null;
                    }
                    if (this._efusion != null) {
                        this._efusion = null;
                    }
                    System.gc();
                    this._img[0] = new Image2("/gfx/introscreen.png", 1, 1, true);
                } else {
                    this._img[3] = new Image2("/gfx/RegularFont1.png", 13, 5, true);
                    this._img[1] = new Image2("/gfx/menuscreen.png", 1, 1, true);
                    this._img[2] = new Image2("/gfx/curseur.png", 1, 9, true);
                    this._img[5] = new Image2("/gfx/pastilles.png", 3, 3, true);
                    this._img[6] = new Image2("/gfx/pastilles_explode.png", 6, 1, true);
                    this._img[7] = new Image2("/gfx/pastilles_fade.png", 7, 1, true);
                    this._img[8] = new Image2("/gfx/interface_3.png", 1, 1, true);
                    this._img[9] = new Image2("/gfx/push.png", 2, 1, true);
                    this._img[10] = new Image2("/gfx/interface_score.png", 1, 2, true);
                    this._img[11] = new Image2("/gfx/shadow.png", 1, 1, true);
                    this._img[12] = new Image2("/gfx/messages.png", 1, 6, true);
                    this._img[28] = new Image2("/gfx/flags.png", 2, 6, true);
                    this.mu.loadMidiWaveFile("/level/5.mid", true, true, 0);
                    if (this._isMusic == 0) {
                        this.mu.startMusic(0);
                    }
                    this._mainState = 4;
                    this._menuState = 0;
                    System.gc();
                }
                this._img[0].draw(graphics, 0, 0, 16 + 4);
                break;
            }
            case 2: {
                if (this._cptLoad == 0) {
                    if (this._img[0] != null) {
                        this._img[0] = null;
                    }
                    System.gc();
                    this._cptLoad = 1;
                } else {
                    this._img[4] = new Image2("/gfx/bg_a.png", 4, 1, true);
                    this._img[15] = new Image2("/gfx/player_E_00.png", 3, 1, true);
                    this._img[16] = new Image2("/gfx/player_E_01.png", 3, 3, true);
                    this._img[17] = new Image2("/gfx/player_E_02.png", 3, 2, true);
                    this._img[18] = new Image2("/gfx/player_E_03.png", 3, 2, true);
                    this._img[19] = new Image2("/gfx/player_E_04.png", 5, 1, true);
                    this._img[20] = new Image2("/gfx/player_E_05.png", 3, 2, true);
                    this._img[21] = new Image2("/gfx/player_E_06.png", 3, 2, true);
                    this._img[22] = new Image2("/gfx/player_E_07.png", 1, 1, true);
                    this._img[13] = new Image2("/gfx/interface.png", 4, 1, true);
                    this._img[14] = new Image2("/gfx/interface_2.png", 1, 1, true);
                    this._img[23] = new Image2("/gfx/interface_4.png", 1, 2, true);
                    this._img[24] = new Image2("/gfx/screen_01.png", 1, 1, true);
                    this._img[25] = new Image2("/gfx/screen_02.png", 1, 1, true);
                    this._img[26] = new Image2("/gfx/gameover_big.png", 1, 1, true);
                    this._img[27] = new Image2("/gfx/megacombo_big.png", 1, 3, true);
                    this._img[29] = new Image2("/gfx/eye_catcher_bigbg_01.png", 1, 1, true);
                    this.mu.stopMusic(0);
                    this.mu.freeMusic();
                    this.mu.loadMidiWaveFile("/level/1_bis.mid", true, true, 0);
                    this._mainState = 5;
                    this._gameState = 0;
                    System.gc();
                }
                this._img[1].draw(graphics, 0, 0, 16 + 4);
                this.mu.print(graphics, 0, 110, 6, 2);
                break;
            }
            case 3: {
                if (this._cptLoad == 0) {
                    ++this._cptLoad;
                    if (this._img[4] != null) {
                        this._img[4] = null;
                    }
                    if (this._img[13] != null) {
                        this._img[13] = null;
                    }
                    if (this._img[14] != null) {
                        this._img[14] = null;
                    }
                    if (this._img[23] != null) {
                        this._img[23] = null;
                    }
                    if (this._img[15] != null) {
                        this._img[15] = null;
                    }
                    if (this._img[16] != null) {
                        this._img[16] = null;
                    }
                    if (this._img[17] != null) {
                        this._img[17] = null;
                    }
                    if (this._img[18] != null) {
                        this._img[18] = null;
                    }
                    if (this._img[19] != null) {
                        this._img[19] = null;
                    }
                    if (this._img[20] != null) {
                        this._img[20] = null;
                    }
                    if (this._img[21] != null) {
                        this._img[21] = null;
                    }
                    if (this._img[22] != null) {
                        this._img[22] = null;
                    }
                    if (this._img[24] != null) {
                        this._img[24] = null;
                    }
                    if (this._img[25] != null) {
                        this._img[25] = null;
                    }
                    if (this._img[26] != null) {
                        this._img[26] = null;
                    }
                    if (this._img[27] != null) {
                        this._img[27] = null;
                    }
                    if (this._img[29] != null) {
                        this._img[29] = null;
                    }
                    System.gc();
                    break;
                }
                this._mainState = 4;
                this.mu.loadMidiWaveFile("/level/5.mid", true, true, 0);
                if (this._isMusic == 0) {
                    this.mu.startMusic(0);
                }
                if (this._enterScore) {
                    this._menuState = 5;
                    this._nbLetter = 0;
                    this._cptLetter = 0;
                    int n = 0;
                    while (n < 3) {
                        this._tmpLetter[n] = 0;
                        n = (byte)(n + 1);
                    }
                } else {
                    this._menuState = 0;
                }
                this._curs = 0;
                break;
            }
            case 4: {
                this.Update_Menu(graphics);
                break;
            }
            case 5: {
                this.Update_Game(graphics);
            }
        }
        if (System.currentTimeMillis() - this.last_paint < 40L) {
            try {
                Thread.sleep(40L - (System.currentTimeMillis() - this.last_paint));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._paint = false;
    }

    public void run() {
        while (this._mainState != 6) {
            this.last_paint = System.currentTimeMillis();
            this.repaint();
            this.serviceRepaints();
            ++this._cptMain;
        }
        this.Save_Records();
        this.GameExit();
        System.gc();
        this.midlet.destroyApp(false);
    }
}

