/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.Event;
import at.emini.physics2D.EventSet;
import at.emini.physics2D.ExternalForce;
import at.emini.physics2D.Joint;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.Motor;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.ShapeSet;
import at.emini.physics2D.Spring;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class World {
    private PhysicsEventListener a;
    private FXVector a;
    private int h = 0;
    private int i = 0;
    private int j = 204;
    private long a;
    private int k = 10;
    private int l = 5;
    private boolean a;
    public static final int M_SHAPE_MAX_VERTICES = 12;
    protected ShapeSet a;
    private EventSet a;
    private Body[] c;
    private int m;
    private int n;
    int a;
    Body[] a;
    private int o = 0;
    private int p = 0;
    private int q;
    private Landscape a;
    int b;
    Contact[] a;
    static int c = 0;
    static Contact[] b = new Contact[32];
    int d = 0;
    Constraint[] a;
    private Vector a;
    private Vector b;
    Script[] a;
    int e = 0;
    Body[] b;
    int[] a;
    int[] b = 0;
    int[] c;
    int f = 0;
    static int g = 0;
    private UserData a = null;

    public World() {
        this.c = new Body[128];
        this.m = Integer.MIN_VALUE;
        this.n = Integer.MAX_VALUE;
        this.a = new Body[128];
        this.q = this.a;
        this.a = new Landscape();
        this.a = new Contact[128];
        this.a = new Constraint[32];
        this.a = new Vector();
        this.b = new Vector();
        this.a = new Script[32];
        this.b = new Body[32];
        this.a = new int[32];
        this.b = new int[32];
        this.c = new int[32];
    }

    public World(World world) {
        this.c = new Body[128];
        this.m = Integer.MIN_VALUE;
        this.n = Integer.MAX_VALUE;
        this.a = new Body[128];
        this.q = this.a;
        this.a = new Landscape();
        this.a = new Contact[128];
        this.a = new Constraint[32];
        this.a = new Vector();
        this.b = new Vector();
        this.a = new Script[32];
        this.b = new Body[32];
        this.a = new int[32];
        this.b = new int[32];
        this.c = new int[32];
        if (world == null) {
            return;
        }
        this.a = world.a.copy();
        this.a.assign(world.a);
        this.h = world.h;
        this.i = world.i;
        this.m = world.m;
        this.n = world.n;
        this.j = world.j;
        this.a = world.a;
        this.k = world.k;
        this.l = world.l;
        this.addWorld(world);
        this.a = world.a.copy();
        if (world.a != null) {
            this.setLandscape(world.a.copy());
        }
        if (world.a != null) {
            this.a = world.a.copy();
        }
    }

    public UserData getUserData() {
        return this.a;
    }

    public void setUserData(UserData userData) {
        this.a = userData;
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader) {
        return World.loadWorld(physicsFileReader, null);
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader, UserData userData) {
        int n = physicsFileReader.getVersion();
        if ((n & 0xFF00) < 256 || (n & 0xFF00) > 2560) {
            return null;
        }
        World world = new World();
        Vector<Shape> vector = new Vector<Shape>();
        Vector<Body> vector2 = new Vector<Body>();
        int n2 = 0;
        while (n2 != -1) {
            switch (n2) {
                case 1: {
                    int n3;
                    int n4;
                    int n5 = physicsFileReader.next();
                    for (n4 = 0; n4 < n5; ++n4) {
                        vector.addElement(Shape.loadShape(physicsFileReader, userData));
                    }
                    if (n > 2048) {
                        n4 = physicsFileReader.next();
                        for (n3 = 0; n3 < n4; ++n3) {
                            vector.addElement(MultiShape.loadShape(physicsFileReader, userData, vector));
                        }
                    }
                    world.a.registerShapes(vector);
                    break;
                }
                case 2: {
                    int n4;
                    int n6 = physicsFileReader.next();
                    for (n4 = 0; n4 < n6; ++n4) {
                        Body body = Body.loadBody(physicsFileReader, vector, userData);
                        vector2.addElement(body);
                        world.addBody(body);
                    }
                    break;
                }
                case 6: {
                    world.setLandscape(Landscape.loadLandscape(physicsFileReader));
                    break;
                }
                case 3: {
                    int n4;
                    int n7 = physicsFileReader.next();
                    for (n4 = 0; n4 < n7; ++n4) {
                        world.addConstraint(World.loadConstraint(physicsFileReader, vector2, userData));
                    }
                    break;
                }
                case 4: {
                    int n3;
                    int n4;
                    int n8 = physicsFileReader.next();
                    for (n4 = 0; n4 < n8; ++n4) {
                        world.addScript(Script.loadScript(physicsFileReader));
                    }
                    world.f = physicsFileReader.next();
                    for (n4 = 0; n4 < world.f; ++n4) {
                        n3 = physicsFileReader.next();
                        int n9 = physicsFileReader.next();
                        if (n9 < 0 || n9 >= vector2.size() || n3 >= n8) continue;
                        world.a[n4] = physicsFileReader.next();
                        world.b[n4] = (Body)vector2.elementAt(physicsFileReader.next());
                    }
                    break;
                }
                case 5: {
                    int n4;
                    int n10 = physicsFileReader.next();
                    for (n4 = 0; n4 < n10; ++n4) {
                        world.addEvent(Event.loadEvent(physicsFileReader, world, userData));
                    }
                    break;
                }
                case 7: {
                    world.setGravity(physicsFileReader.nextVector());
                    if (physicsFileReader.getVersion() > 2304) {
                        world.setDampingLateralFX(physicsFileReader.nextInt());
                        world.setDampingRotationalFX(physicsFileReader.nextInt());
                    } else {
                        int n11 = 4096 - physicsFileReader.nextInt();
                        world.setDampingLateralFX(n11);
                        world.setDampingRotationalFX(n11);
                    }
                    if (physicsFileReader.getVersion() <= 1792) break;
                    String string = physicsFileReader.nextString();
                    if (userData == null) break;
                    world.a = userData.createNewUserData(string, 6);
                    break;
                }
                case 8: {
                    int n4;
                    int n12 = physicsFileReader.next();
                    for (n4 = 0; n4 < n12; ++n4) {
                        world.addParticleEmitter(ParticleEmitter.loadParticleEmitter(physicsFileReader, world, userData));
                    }
                    break;
                }
            }
            if ((n & 0xFF00) == 256) {
                if (++n2 == 4) {
                    ++n2;
                }
                if (n2 <= 5) continue;
                break;
            }
            n2 = physicsFileReader.next();
        }
        physicsFileReader.close();
        return world;
    }

    public int getTimestepFX() {
        return this.j;
    }

    public long getInverseTimestepFX() {
        return this.a;
    }

    public void setTimestepFX(int n) {
        this.j = n;
        this.a = 0x1000000 / this.j;
    }

    public void setConstraintIterations(int n) {
        this.k = n;
    }

    public void setPositionConstraintIterations(int n) {
        this.l = n;
    }

    public int getConstraintIterations() {
        return this.k;
    }

    public int getPositionConstraintIterations() {
        return this.l;
    }

    public void setConstraintIterationDynamic(boolean bl) {
        this.a = bl;
    }

    public void setPhysicsEventListener(PhysicsEventListener physicsEventListener) {
        this.a = physicsEventListener;
    }

    public void setSimulationArea(int n, int n2) {
        this.m = n << 12;
        this.n = n2 << 12;
    }

    public ShapeSet getShapeSet() {
        return this.a;
    }

    public Body[] addWorld(World world) {
        Body body;
        int n;
        Body[] bodyArray = new Body[world.o];
        for (n = 0; n < world.a; ++n) {
            body = world.a[n].copy();
            this.addBody(body);
            body.a(0);
            bodyArray[world.a[n].h] = body;
        }
        for (n = 0; n < world.d; ++n) {
            this.addConstraint(world.a[n].copy(bodyArray));
        }
        for (n = 0; n < world.e; ++n) {
            this.addScript(world.a[n].copy());
        }
        for (n = 0; n < world.f; ++n) {
            body = bodyArray[world.b[n].h];
            this.a[world.a[n]].applyToBody(body, this);
            this.b[n] = world.b[n];
            this.c[n] = world.c[n];
        }
        for (n = 0; n < world.a.size(); ++n) {
            this.addParticleEmitter(((ParticleEmitter)world.a.elementAt(n)).copy(bodyArray));
        }
        for (n = 0; n < world.b.size(); ++n) {
            this.addExternalForce(((ExternalForce)world.b.elementAt(n)).copy(bodyArray));
        }
        Vector vector = world.a.getEvents();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            this.addEvent(((Event)vector.elementAt(i)).copy(bodyArray));
        }
        Landscape landscape = world.getLandscape();
        for (int i = 0; i < landscape.a; ++i) {
            this.a.addSegment(new FXVector(landscape.a[i]), new FXVector(landscape.b[i]), landscape.a[i]);
        }
        return bodyArray;
    }

    public void addBody(Body body) {
        if (body != null) {
            body.h = this.o++;
            this.a = World.a(this.a, this.a);
            this.a[this.a++] = body;
            this.a.registerShape(body.a);
            this.a();
            body.forceUpdate(this.j);
        }
    }

    public void setLandscape(Landscape landscape) {
        this.a = landscape;
    }

    public Landscape getLandscape() {
        return this.a;
    }

    public void addParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.a.addElement(particleEmitter);
        }
    }

    public void addExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.b.addElement(externalForce);
        }
    }

    public void removeBody(Body body) {
        int n;
        int n2;
        if (body.h < 0) {
            return;
        }
        for (n2 = 0; n2 < this.a; ++n2) {
            if (this.a[n2] != body) continue;
            this.a[n2] = null;
            break;
        }
        this.a = World.a((Object[])this.a, this.a);
        this.a();
        for (n2 = 0; n2 < this.f; ++n2) {
            if (this.b[n2] != body) continue;
            this.b[n2] = -1;
            this.c[n2] = -1;
            this.a[n2] = -1;
            this.b[n2] = null;
            World.a(this.b, this.f);
            World.a(this.c, this.f);
            World.a(this.a, this.f);
            this.f = World.a((Object[])this.b, this.f);
        }
        n2 = this.d;
        for (n = 0; n < n2; ++n) {
            if (!this.a[n].concernsBody(body)) continue;
            this.a[n] = null;
        }
        this.d = World.a(this.a, this.d);
        for (n2 = this.a.size() - 1; n2 >= 0; --n2) {
            if (((ParticleEmitter)this.a.elementAt(n2)).getEmitter() != body) continue;
            this.a.removeElementAt(n2);
        }
        n2 = this.b;
        for (n = 0; n < n2; ++n) {
            if (!this.a[n].concernsBody(body)) continue;
            this.a[n] = null;
        }
        this.b = World.a((Object[])this.a, this.b);
    }

    public void removeConstraint(Constraint constraint) {
        int n = this.d;
        for (int i = 0; i < n; ++i) {
            if (this.a[i] != constraint) continue;
            this.a[i] = null;
        }
        this.d = World.a(this.a, this.d);
    }

    public void removeScript(Script script) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.e; ++n) {
            if (this.a[n] != script) continue;
            this.a[n] = null;
            n2 = n;
            --this.e;
            for (int i = n; i < this.e; ++i) {
                this.a[i] = this.a[i + 1];
            }
            break;
        }
        for (n = 0; n < this.f; ++n) {
            if (this.b[n] != n2) continue;
            this.b[n] = -1;
            this.c[n] = -1;
            this.a[n] = -1;
            this.b[n] = null;
            World.a(this.b, this.f);
            World.a(this.c, this.f);
            World.a(this.a, this.f);
            this.f = World.a((Object[])this.b, this.f);
            return;
        }
    }

    public void removeEvent(Event event) {
        this.a.removeEvent(event);
    }

    public void removeParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.a.removeElement(particleEmitter);
        }
    }

    public void removeExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.b.removeElement(externalForce);
        }
    }

    static final int[] a(int[] nArray, int n) {
        if (nArray.length <= n) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    static final short[] a(short[] sArray, int n) {
        if (sArray.length <= n) {
            short[] sArray2 = new short[sArray.length + 32];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    private static Body[] a(Body[] bodyArray, int n) {
        if (bodyArray.length <= n) {
            Body[] bodyArray2 = new Body[bodyArray.length + 32];
            System.arraycopy(bodyArray, 0, bodyArray2, 0, bodyArray.length);
            return bodyArray2;
        }
        return bodyArray;
    }

    static final Contact[] a(Contact[] contactArray, int n) {
        if (contactArray.length <= n) {
            Contact[] contactArray2 = new Contact[contactArray.length + 32];
            System.arraycopy(contactArray, 0, contactArray2, 0, contactArray.length);
            return contactArray2;
        }
        return contactArray;
    }

    static final FXVector[] a(FXVector[] fXVectorArray, int n) {
        if (fXVectorArray.length <= n) {
            FXVector[] fXVectorArray2 = new FXVector[fXVectorArray.length + 32];
            System.arraycopy(fXVectorArray, 0, fXVectorArray2, 0, fXVectorArray.length);
            return fXVectorArray2;
        }
        return fXVectorArray;
    }

    public Body findBodyById(int n) {
        if ((n = this.bodyIndexOf(n)) < 0) {
            return null;
        }
        return this.a[n];
    }

    public Body findBodyAt(int n, int n2) {
        Body[] bodyArray = this.getBodies();
        FXVector fXVector = new FXVector();
        for (int i = 0; i < this.getBodyCount(); ++i) {
            Body body = bodyArray[i];
            fXVector.assignFX(n, n2);
            if (n < body.getAABBMinXFX() || n > body.getAABBMaxXFX() || n2 < body.getAABBMinYFX() || n2 > body.getAABBMaxYFX()) continue;
            FXVector[] fXVectorArray = body.getAxes();
            FXVector[] fXVectorArray2 = body.getVertices();
            boolean bl = true;
            for (int j = 0; j < fXVectorArray.length; ++j) {
                long l;
                long l2 = (long)fXVector.xFX * (long)fXVectorArray[j].xFX + (long)fXVector.yFX * (long)fXVectorArray[j].yFX >> 12;
                long l3 = l = (long)fXVectorArray2[0].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[0].yFX * (long)fXVectorArray[j].yFX >> 12;
                for (int k = 1; k < fXVectorArray2.length; ++k) {
                    long l4 = (long)fXVectorArray2[k].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[k].yFX * (long)fXVectorArray[j].yFX >> 12;
                    if (l > l4) {
                        l = l4;
                    }
                    if (l3 >= l4) continue;
                    l3 = l4;
                }
                if (l <= l2 && l3 >= l2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return body;
        }
        return null;
    }

    public int bodyIndexOf(int n) {
        for (int i = 0; i < this.a; ++i) {
            if (this.a[i].h != n) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Constraint constraint) {
        if (constraint == null) {
            return -1;
        }
        for (int i = 0; i < this.d; ++i) {
            if (!this.a[i].equals(constraint)) continue;
            return i;
        }
        return -1;
    }

    public void addConstraint(Constraint constraint) {
        if (constraint != null) {
            Constraint[] constraintArray;
            int n = this.d;
            Constraint[] constraintArray2 = this.a;
            if (this.a.length <= n) {
                Constraint[] constraintArray3 = new Constraint[constraintArray2.length + 32];
                System.arraycopy(constraintArray2, 0, constraintArray3, 0, constraintArray2.length);
                constraintArray = constraintArray3;
            } else {
                constraintArray = constraintArray2;
            }
            this.a = constraintArray;
            this.a[this.d++] = constraint;
        }
    }

    public void addScript(Script script) {
        if (script != null) {
            Script[] scriptArray;
            int n = this.e;
            Script[] scriptArray2 = this.a;
            if (this.a.length <= n) {
                Script[] scriptArray3 = new Script[scriptArray2.length + 32];
                System.arraycopy(scriptArray2, 0, scriptArray3, 0, scriptArray2.length);
                scriptArray = scriptArray3;
            } else {
                scriptArray = scriptArray2;
            }
            this.a = scriptArray;
            this.a[this.e++] = script;
        }
    }

    public void addEvent(Event event) {
        this.a.registerEvent(event);
    }

    public void setGravity(int n) {
        this.a = new FXVector(0, n << 12);
    }

    public void setGravity(FXVector fXVector) {
        this.a = fXVector;
    }

    public void setDampingLateralFX(int n) {
        this.h = n;
    }

    public void setDampingRotationalFX(int n) {
        this.i = n;
    }

    public void tick() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Body[] bodyArray = this.a;
        Constraint[] constraintArray = this.a;
        for (n6 = 0; n6 < this.f; ++n6) {
            if (this.b[n6] == null) continue;
            this.a[this.a[n6]].a(n6, this);
        }
        for (n6 = 0; n6 < this.b.size(); ++n6) {
            ((ExternalForce)this.b.elementAt(n6)).applyForce(bodyArray, this.a, this.j);
        }
        for (n6 = this.p; n6 < this.q; ++n6) {
            Body body = bodyArray[n6];
            if (body.a && body.c) {
                body.applyAcceleration(this.a, this.j);
            }
            body.a(this.j);
        }
        World world = this;
        for (n5 = 0; n5 < world.b; ++n5) {
            world.a[n5] = null;
        }
        n5 = world.b = 0;
        world.a.a();
        world.a();
        int n7 = 0;
        int n8 = 0;
        for (n4 = world.p; n4 < world.q; ++n4) {
            n3 = world.a[n4].c;
            world.a.a(world, world.a[n4]);
            for (int i = 0; i < n8; ++i) {
                if (world.c[i] == null) continue;
                if (world.c[i].d < n3) {
                    --n7;
                    world.c[i] = null;
                    continue;
                }
                if (world.a[n4].e > world.c[i].f || world.c[i].e > world.a[n4].f) continue;
                Body body = world.c[i];
                Body body2 = world.a[n4];
                World world2 = world;
                if (!body2.a && !body.a || (body2.g & body.g) != 0 || !body2.b || !body.b) continue;
                if (body2.a instanceof MultiShape || body.a instanceof MultiShape) {
                    int n9 = 1;
                    int n10 = 1;
                    if (body2.a instanceof MultiShape) {
                        n9 = ((MultiShape)body2.a).getShapeCount();
                    }
                    if (body.a instanceof MultiShape) {
                        n10 = ((MultiShape)body.a).getShapeCount();
                    }
                    for (int j = 0; j < n9; ++j) {
                        for (int k = 0; k < n10; ++k) {
                            Contact contact = Collision.detectCollision(body2, j, body, k);
                            if (contact == null) continue;
                            world2.a = World.a(world2.a, world2.b);
                            world2.a[world2.b] = contact;
                            ++world2.b;
                        }
                    }
                    continue;
                }
                Contact contact = Collision.detectCollision(body2, body);
                if (contact == null) continue;
                world2.a = World.a(world2.a, world2.b);
                world2.a[world2.b] = contact;
                ++world2.b;
            }
            world.c = World.a(world.c, n8);
            world.c[n8++] = world.a[n4];
            if (n8 <= ++n7 << 1) continue;
            n8 = World.a((Object[])world.c, n8);
        }
        world.a.b();
        for (n4 = world.p; n4 < world.q; ++n4) {
            world.a[n4].a();
        }
        world.a.getBody();
        for (n3 = n5; n3 < world.b; ++n3) {
            Contact contact = world.a[n3];
            world.a[n3].a = false;
            contact.a.a(contact);
            contact.b.a(contact);
        }
        Contact.a(this.a, this.b);
        Contact.a(this.a, this.b, this.a);
        for (int i = 0; i < this.a.size(); ++i) {
            ((ParticleEmitter)this.a.elementAt(i)).applyAcceleration(this.a, this.j);
        }
        World world3 = this;
        for (n2 = 0; n2 < world3.a.size(); ++n2) {
            ParticleEmitter particleEmitter = (ParticleEmitter)world3.a.elementAt(n2);
            if (!particleEmitter.a) continue;
            n8 = 0;
            for (n3 = world3.p; n3 < world3.q; ++n3) {
                while (n8 < particleEmitter.a && (particleEmitter.a[n8] <= 0 || world3.a[n3].c > particleEmitter.a[n8])) {
                    ++n8;
                }
                for (n4 = n8; n4 < particleEmitter.a && (particleEmitter.a[n4] <= 0 || world3.a[n3].d > particleEmitter.a[n4]); ++n4) {
                    FXVector fXVector;
                    if (particleEmitter.a[n4] <= 0 || world3.a[n3].e >= particleEmitter.b[n4] || world3.a[n3].f <= particleEmitter.b[n4] || !world3.a[n3].b || (fXVector = Collision.a(world3.a[n3], particleEmitter.a[n4], particleEmitter.b[n4])) == null) continue;
                    particleEmitter.a(fXVector, n4);
                }
            }
            world3.a.collideParticles(particleEmitter);
        }
        for (n = 0; n < this.b; ++n) {
            this.a[n].a(this.a);
        }
        for (n = 0; n < this.d; ++n) {
            constraintArray[n].precalculate(this.a);
        }
        n = 0;
        for (g = 0; !(g >= this.k || n != 0 && this.a); ++g) {
            n = 1;
            for (n2 = 0; n2 < this.d; ++n2) {
                n &= constraintArray[n2].applyMomentum(this.a);
            }
            for (n2 = 0; n2 < this.b; ++n2) {
                n &= this.a[n2].a();
            }
        }
        for (n2 = 0; n2 < this.d; ++n2) {
            constraintArray[n2].postStep();
        }
        n2 = 4096 - this.h;
        int n11 = 4096 - this.i;
        for (n7 = this.p; n7 < this.q; ++n7) {
            bodyArray[n7].integrateVelocity(this.j);
            bodyArray[n7].a(n2, n11);
        }
        for (n7 = 0; n7 < this.b; ++n7) {
            this.a[n7].a(this.j, this.a);
        }
        long l = 0L;
        for (g = 0; g < this.l; ++g) {
            for (n11 = 0; n11 < this.b; ++n11) {
                long l2 = this.a[n11].a();
                l = l < l2 ? l2 : l;
            }
            if (l < 32L) break;
        }
        for (n11 = this.p; n11 < this.q; ++n11) {
            bodyArray[n11].integrateVirtualVelocity(this.j, this.a);
        }
        for (n11 = 0; n11 < this.a.size(); ++n11) {
            ((ParticleEmitter)this.a.elementAt(n11)).integrateParticles(this.j);
        }
        if (this.a != null) {
            this.a.checkEvents(this, this.a);
        }
    }

    private static int a(Object[] objectArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (objectArray[n3] != null && n3 < n) {
                ++n3;
            }
            while (objectArray[n] == null && n3 < n) {
                --n;
            }
            if (n3 < n) {
                objectArray[n3] = objectArray[n];
                objectArray[n] = null;
            }
            if (objectArray[n] == null) {
                n2 = n;
            }
            --n;
        }
        while (n2 > 0 && objectArray[n2 - 1] == null) {
            --n2;
        }
        return n2;
    }

    static final int a(int[] nArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (nArray[n3] != -1 && n3 < n) {
                ++n3;
            }
            while (nArray[n] == -1 && n3 < n) {
                --n;
            }
            if (n3 < n) {
                nArray[n3] = nArray[n];
                nArray[n] = -1;
                n2 = n;
            }
            --n;
        }
        return n2;
    }

    private final void a() {
        int n;
        for (n = 1; n < this.a; ++n) {
            Body body = this.a[n];
            for (int i = n - 1; i >= 0 && this.a[i].c > body.c; --i) {
                this.a[i + 1] = this.a[i];
            }
            this.a[i + 1] = body;
        }
        this.p = -1;
        this.q = this.a;
        for (n = 0; n < this.a; ++n) {
            if (this.p < 0 && this.a[n].d > this.m) {
                this.p = n;
            }
            if (this.a[n].c >= this.n) continue;
            this.q = n + 1;
        }
        if (this.p < 0) {
            this.p = 0;
        }
    }

    public FXVector getGravity() {
        return this.a;
    }

    public int getDampingLateralFX() {
        return this.h;
    }

    public int getDampingRotationalFX() {
        return this.i;
    }

    public static Constraint loadConstraint(PhysicsFileReader physicsFileReader, Vector vector, UserData userData) {
        switch (physicsFileReader.next()) {
            case 0: {
                return Joint.loadJoint(physicsFileReader, vector, userData);
            }
            case 1: {
                return Spring.loadSpring(physicsFileReader, vector, userData);
            }
            case 3: {
                return Motor.loadMotor(physicsFileReader, vector, userData);
            }
        }
        return null;
    }

    public Vector getEvents() {
        return this.a.getEvents();
    }

    public Vector getParticleEmitters() {
        return this.a;
    }

    public int getBodyCount() {
        return this.a;
    }

    public Body[] getBodies() {
        return this.a;
    }

    public int getBodyStartIndex() {
        return this.p;
    }

    public int getBodyEndIndex() {
        return this.q;
    }

    public int getConstraintCount() {
        return this.d;
    }

    public Constraint[] getConstraints() {
        return this.a;
    }

    public int getContactCount() {
        return this.b;
    }

    public Contact[] getContacts() {
        return this.a;
    }

    public int getScriptCount() {
        return this.e;
    }

    public Script[] getScripts() {
        return this.a;
    }

    public Script getScript(int n) {
        return this.a[n];
    }

    public Contact[] getContactsForBody(Body contactArray) {
        Contact[] contactArray2 = new Contact[8];
        int n = 0;
        contactArray = contactArray.getContacts();
        for (int i = 0; i < contactArray.length && contactArray[i] != null; ++i) {
            contactArray2[n++] = contactArray[i];
        }
        return contactArray2;
    }

    public void translate(FXVector fXVector) {
        int n = this.getBodyCount();
        Body[] bodyArray = this.getBodies();
        for (int i = 0; i < n; ++i) {
            bodyArray[i].positionFX().xFX += fXVector.xFX;
            bodyArray[i].positionFX().yFX += fXVector.yFX;
            bodyArray[i].a(0);
        }
    }

    public long getBodyTotalEnergyFX(Body body) {
        long l = body.velocityFX().lengthSquareFX() / 2;
        long l2 = (long)(-((int)((long)body.positionFX().yFX * (long)this.a.yFX) >> 12)) + (long)(-((int)((long)body.positionFX().xFX * (long)this.a.xFX) >> 12));
        return l + l2;
    }
}

