/*
 * Decompiled with CFR 0.152.
 */
package com.sensiblemobiles.RoadFighting;

import com.sensiblemobiles.RoadFighting.CommanFunctions;
import com.sensiblemobiles.RoadFighting.Configuration;
import com.sensiblemobiles.RoadFighting.MainCanvas;
import com.sensiblemobiles.game.MainGameCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LevelSelection {
    private int screenWidth;
    private int screenHeight;
    private Image UnlockLevel;
    private Image LockedLevel;
    private int unlocked = 1;
    private Font font;
    private int Xcord;
    private int Ycord;
    private int selectIndex = 0;
    private int MaxLevel;
    public static String levelun = "levelun";
    private int topAdHeight;
    private int bottomAdHeight;
    private int buttonSize;
    private int noOfRow = 4;
    private int noOfCols;

    public LevelSelection(int width, int height, int maxLevel) {
        this.screenWidth = width;
        this.screenHeight = height;
        this.MaxLevel = maxLevel;
        this.topAdHeight = this.screenHeight * 15 / 100;
        this.unlocked = LevelSelection.getUnlockedLevel();
        this.font = Font.getFont((int)32, (int)1, (int)8);
        try {
            this.UnlockLevel = Image.createImage((String)"/res/levelSelection/UnlockLevel.png");
            this.UnlockLevel = CommanFunctions.scale(this.UnlockLevel, this.screenWidth * 20 / 100, this.screenWidth * 20 / 100);
            this.LockedLevel = Image.createImage((String)"/res/levelSelection/LockedLevel.png");
            this.LockedLevel = CommanFunctions.scale(this.LockedLevel, this.screenWidth * 20 / 100, this.screenWidth * 20 / 100);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.MaxLevel > 16) {
            this.noOfRow = 4;
            this.noOfCols = this.MaxLevel / this.noOfRow;
        } else {
            this.noOfRow = 4;
            this.noOfCols = this.MaxLevel / this.noOfRow + 2;
        }
        this.buttonSize = this.screenWidth / this.noOfCols;
        if (this.screenHeight < this.buttonSize * 5 + this.topAdHeight + this.bottomAdHeight) {
            this.buttonSize = (this.screenHeight - (this.topAdHeight + this.bottomAdHeight)) / 5;
        }
        this.UnlockLevel = CommanFunctions.scale(this.UnlockLevel, this.buttonSize, this.buttonSize);
        this.LockedLevel = CommanFunctions.scale(this.LockedLevel, this.buttonSize, this.buttonSize);
        this.Xcord = (this.screenWidth - this.buttonSize * (this.noOfCols - 1)) / this.noOfCols;
        this.Ycord = this.topAdHeight + 5;
    }

    public static void setUnlockedLevel(int level) {
        if (LevelSelection.getUnlockedLevel() < level) {
            Configuration.Set(levelun, "" + level);
        }
    }

    public static int getUnlockedLevel() {
        int unl_lev = 5;
        String temp = Configuration.Get(levelun);
        unl_lev = temp.length() > 0 ? Integer.parseInt(temp) : 5;
        return unl_lev;
    }

    public void paint(Graphics g) {
        this.unlocked = LevelSelection.getUnlockedLevel();
        if (MainCanvas.background != null) {
            g.drawImage(MainCanvas.background, this.screenWidth / 2, this.screenHeight / 2, 3);
        }
        int Tycord = this.Ycord;
        int Txcord = this.Xcord;
        for (int i = 0; i < this.MaxLevel; ++i) {
            if (this.selectIndex == i) {
                g.setColor(-16018477);
                g.fillRect(Txcord, Tycord, this.buttonSize, this.buttonSize);
            }
            int a = i + 1;
            if (i < this.unlocked) {
                g.drawImage(this.UnlockLevel, Txcord, Tycord, 0);
                g.setColor(0xFFFFFF);
                g.drawString("" + a, Txcord + this.UnlockLevel.getWidth() / 2, Tycord + this.UnlockLevel.getHeight() / 2 - this.font.getHeight() / 2, 17);
            } else {
                g.drawImage(this.LockedLevel, Txcord, Tycord, 0);
                g.setColor(0xFFFFFF);
            }
            Txcord += this.buttonSize + this.Xcord;
            if ((i + 1) % (this.noOfCols - 1) != 0) continue;
            Txcord = this.Xcord;
            Tycord += this.buttonSize + this.buttonSize / this.noOfCols;
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -3) {
            this.selectIndex = this.selectIndex <= 1 ? this.MaxLevel - 1 : --this.selectIndex;
        } else if (keyCode == -4) {
            this.selectIndex = this.selectIndex >= this.MaxLevel - 1 ? 0 : ++this.selectIndex;
        } else if (keyCode == -1) {
            this.selectIndex = this.selectIndex <= 1 ? this.MaxLevel - 2 : (this.selectIndex -= this.noOfCols - 1);
        } else if (keyCode == -2) {
            this.selectIndex = this.selectIndex >= this.MaxLevel - 2 ? 0 : (this.selectIndex += this.noOfCols - 1);
        } else if (keyCode == -5) {
            if (this.selectIndex == 13 || this.selectIndex == 0) {
                // empty if block
            }
            for (int i = 0; i < this.unlocked; ++i) {
                if (this.selectIndex != i) continue;
                MainGameCanvas.mainGameCanvas.setLevelValue((byte)(this.selectIndex + 1));
            }
        }
    }

    public void pointerPressed(int x, int y) {
        int Tycord = this.Ycord;
        int Txcord = this.Xcord;
        for (int i = 0; i < this.unlocked; ++i) {
            if (y > Tycord && y < Tycord + this.UnlockLevel.getHeight() && x > Txcord && x < Txcord + this.UnlockLevel.getWidth()) {
                this.selectIndex = i;
                this.keyPressed(-5);
            }
            Txcord += this.buttonSize + this.Xcord;
            if ((i + 1) % (this.noOfCols - 1) != 0) continue;
            Txcord = this.Xcord;
            Tycord += this.buttonSize + this.buttonSize / this.noOfCols;
        }
    }
}

