/*
 * Decompiled with CFR 0.152.
 */
package com.game;

import com.game.Background;
import com.game.BoosterCoin;
import com.game.Res;
import com.mainGame.Configuration;
import com.mainGame.Midlet;
import com.mainGame.SoundHandler;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import smapps.Advertisements;
import smapps.AdvertisementsListner;

public class GameCanvas
extends Canvas
implements CommandListener,
AdvertisementsListner {
    Midlet md;
    int WW;
    int HH;
    Background[] background;
    public int screen;
    public int gameScreen;
    public int gameOverScreen = 1;
    int bgX;
    int bgX1;
    LayerManager lm;
    Sprite playerSprite;
    Sprite effectSprite;
    int lmHeight;
    int playerSpeed = 8;
    BoosterCoin[] bc;
    int score;
    Sprite spriteC;
    SoundHandler soundHandler;
    private Command backCommand;
    Res res;
    private Advertisements advertisements;
    private int fullAdScreen = 16;
    private int seLadd;
    int currentScore;
    int bgChanger;
    boolean start;
    boolean startTimer;
    int counter;
    int boostCounter;
    int playerX;
    int playerY;
    int index;
    int indexCounter;
    boolean booster;
    int coin;
    int y1;
    boolean oneTimeDragged;
    int x2;
    boolean downpointer;
    boolean uppointer;
    boolean upCollision;
    boolean downCollision;
    boolean up;
    boolean down;
    boolean isPaused = true;
    int coinIndex;
    int highScore;
    int skipAction = -1;

    public GameCanvas(Midlet md) {
        this.setFullScreenMode(true);
        this.md = md;
        this.bc = new BoosterCoin[2];
        this.background = new Background[2];
        this.advertisements = Advertisements.getInstanse(md, this.WW, this.HH, this, this, Midlet.isRFWP);
        this.WW = this.getWidth();
        this.HH = this.getHeight();
        this.res = new Res();
        this.res.scaleData(this.WW, this.HH);
        this.playerSprite = new Sprite(Res.player, Res.player.getWidth() / 4, Res.player.getHeight());
        this.playerSprite.setPosition(this.playerX, this.playerY);
        this.effectSprite = new Sprite(Res.effect, Res.effect.getWidth() / 4, Res.effect.getHeight());
        this.generateBg();
        this.lm = new LayerManager();
        this.lm.append((Layer)this.playerSprite);
        for (int i = 0; i < 2; ++i) {
            this.lm.append((Layer)this.background[i].base);
        }
        this.spriteC = new Sprite(Res.coin, Res.coin.getWidth() / 10, Res.coin.getHeight());
        this.run();
        this.start = true;
        this.setDATA();
        this.playerSprite.setPosition(this.playerX, this.playerY);
        this.effectSprite.setPosition(this.playerX, this.playerY);
        this.generateBC();
        this.soundHandler = new SoundHandler(md);
        this.soundHandler.loadSound("/res/bg.mid", 2);
        if (Midlet.isNokiaAsha501()) {
            this.backCommand = new Command("BACK", 2, 1);
            this.addCommand(this.backCommand);
            this.setCommandListener(this);
        }
    }

    public void setDATA() {
        this.playerX = Res.pause.getWidth();
        this.playerY = this.HH - (this.playerSprite.getHeight() - 4 + this.playerSprite.getHeight());
    }

    protected void paint(Graphics g) {
        this.advertisements.setAdvertisementsListner(this);
        if (this.screen == this.gameScreen) {
            if (!this.startTimer) {
                g.drawImage(Res.startImage, this.WW / 2, this.HH / 2, 3);
            }
            this.drawBackground(g);
            this.advertisements.drawAdds(g, 0, 0);
            this.advertisements.setShowFullScreenAdd(false);
            this.drawPlayer(g);
            this.drawBoosterCoin(g);
            this.drawScore(g);
            this.coilision();
            if (this.isPaused) {
                g.drawImage(Res.resume, 0, this.HH - Res.resume.getHeight(), 0);
                g.drawImage(Res.pausedImg, this.WW / 2, this.HH / 2, 3);
            } else {
                g.drawImage(Res.pause, 0, this.HH - Res.resume.getHeight(), 0);
            }
            if (!Midlet.isNokiaAsha501()) {
                g.drawImage(Res.back, this.WW - Res.back.getWidth(), this.HH - Res.back.getHeight(), 0);
            }
        } else if (this.screen == this.gameOverScreen) {
            g.drawImage(Res.menuBg, 0, 0, 0);
            this.advertisements.drawAdds(g, 0, 0);
            this.advertisements.setShowFullScreenAdd(false);
            g.drawImage(Res.textBg, this.WW - Res.textBg.getWidth() - 10, Res.pause.getHeight(), 0);
            g.drawImage(Res.gameOverImg, this.WW - Res.textBg.getWidth() - 10, Res.pause.getHeight(), 0);
            g.setFont(this.md.mainCanvas.f1);
            g.setColor(0);
            g.drawString("Score: " + this.currentScore, this.WW - Res.textBg.getWidth(), Res.textBg.getHeight() / 2 + this.md.mainCanvas.f1.getHeight(), 0);
            g.drawString("H .S: " + this.getHighScore(), this.WW - Res.textBg.getWidth(), Res.textBg.getHeight() / 2 + this.md.mainCanvas.f1.getHeight() + 30, 0);
            g.drawImage(Res.retry, 0, this.HH - Res.retry.getHeight(), 0);
            if (!Midlet.isNokiaAsha501()) {
                g.drawImage(Res.back, this.WW - Res.back.getWidth(), this.HH - Res.back.getHeight(), 0);
            }
        } else if (this.screen == this.fullAdScreen) {
            this.advertisements.setAddSelectedColor(-16736780);
            this.advertisements.setShowFullScreenAdd(true);
            boolean b2 = this.advertisements.drawFullScreenAdd(g);
            if (!b2) {
                this.advertisementsCallBack(Advertisements.skipAddCode);
            }
        }
    }

    private void drawBackground(Graphics g) {
        g.drawImage(Res.bg[this.bgChanger], this.background[0].xCord, 0, 0);
        g.drawImage(Res.bg[this.bgChanger], this.background[1].xCord, 0, 0);
        if (this.screen == this.gameScreen) {
            for (int i = 0; i < 2; ++i) {
                if (this.background[i] == null) continue;
                this.background[i].doPaint(g);
            }
        }
        this.setPosition();
    }

    public void setPosition() {
        for (int i = 0; i < 2; ++i) {
            if (this.background[i] == null || this.background[i].xCord > -this.WW) continue;
            this.background[i].createBase();
            this.background[i].xCord += Res.bg[0].getWidth() * 2;
        }
    }

    public void generateBg() {
        for (int i = 0; i < 2; ++i) {
            if (this.background[i] != null) continue;
            this.background[i] = i == 0 ? new Background(this, this.WW, this.HH, 0, 0) : new Background(this, this.WW, this.HH, this.WW, 0);
        }
    }

    public void run() {
        new Thread(new Runnable(){

            public void run() {
                while (GameCanvas.this.start) {
                    try {
                        Thread.sleep(60L);
                        if (!GameCanvas.this.startTimer) continue;
                        if (GameCanvas.this.screen == GameCanvas.this.gameScreen) {
                            GameCanvas.this.update();
                        }
                        GameCanvas.this.repaint();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private void update() {
        for (int i = 0; i < 2; ++i) {
            if (this.background[i] == null) continue;
            this.background[i].xCord -= this.playerSpeed;
        }
        if (this.counter == 10) {
            ++this.score;
            this.counter = 0;
        }
        ++this.counter;
        if (this.booster) {
            if (this.boostCounter == 100) {
                this.boostCounter = 0;
                this.booster = false;
            }
            ++this.boostCounter;
            if (this.score > 300) {
                this.playerSpeed = 14;
                this.bgChanger = 2;
            } else {
                this.playerSpeed = 12;
            }
        } else if (this.score > 200) {
            this.playerSpeed = 10;
            this.bgChanger = 1;
        } else {
            this.playerSpeed = 8;
        }
        this.handlePlayer();
    }

    private void drawPlayer(Graphics g) {
        if (this.background[0].isCollision || this.background[1].isCollision) {
            if (this.up) {
                this.playerSprite.setTransform(1);
                this.effectSprite.setTransform(1);
            } else if (this.down) {
                this.playerSprite.setTransform(0);
                this.effectSprite.setTransform(0);
            }
        }
        this.playerSprite.setFrame(this.index);
        if (this.booster) {
            this.effectSprite.setFrame(this.index);
            this.effectSprite.paint(g);
        }
        this.lm.paint(g, 0, this.lmHeight);
        if (this.index < 3) {
            if (this.indexCounter == 2) {
                ++this.index;
                this.indexCounter = 0;
            }
            ++this.indexCounter;
        } else {
            this.index = 1;
        }
    }

    private void coilision() {
        for (int i = 0; i < 2; ++i) {
            if (this.background[i] != null) {
                if (this.playerSprite.collidesWith(this.background[i].base, true)) {
                    this.background[i].isCollision = true;
                } else {
                    this.background[i].isCollision = false;
                    this.upCollision = false;
                    this.downCollision = false;
                    this.callGameOver();
                }
            }
            if (!this.playerSprite.collidesWith(this.bc[i].sprite, true)) continue;
            if (this.bc[i].a == 2) {
                this.booster = true;
            } else {
                this.score += 10;
            }
            this.bc[i].sprite.setVisible(false);
        }
    }

    private void handlePlayer() {
        if (this.up && !this.background[0].isCollision && !this.background[1].isCollision) {
            this.playerSprite.move(0, -this.playerSpeed);
            this.effectSprite.move(0, -this.playerSpeed);
        }
        if (this.down && !this.background[0].isCollision && !this.background[1].isCollision) {
            this.playerSprite.move(0, this.playerSpeed);
            this.effectSprite.move(0, this.playerSpeed);
        }
        if (this.upCollision) {
            this.playerSprite.move(0, -this.playerSpeed);
            this.effectSprite.move(0, -this.playerSpeed);
        }
        if (this.downCollision) {
            this.playerSprite.move(0, this.playerSpeed);
            this.effectSprite.move(0, this.playerSpeed);
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.screen == this.gameScreen) {
            if (!this.startTimer) {
                if (x > 0 && x < this.WW && y > 0 && y < this.HH) {
                    this.keyPressed(-5);
                }
            } else if (x > 0 && x < this.WW) {
                if (y > 0 && y < this.HH / 2) {
                    this.keyPressed(-1);
                } else if (y > this.HH / 2 && y < this.HH) {
                    this.keyPressed(-2);
                }
            }
        }
        if (y > this.HH - Res.pause.getHeight() && y < this.HH) {
            if (x > 0 && x < Res.pause.getWidth()) {
                this.keyPressed(-6);
            } else if (x > this.WW - Res.pause.getWidth() && x < this.WW && !Midlet.isNokiaAsha501()) {
                this.keyPressed(-7);
            }
        }
        if (this.advertisements != null) {
            this.advertisements.pointerPressed(x, y);
        }
        this.repaint();
    }

    protected void keyPressed(int keyCode) {
        if (this.screen == this.gameScreen) {
            if (keyCode == -1) {
                if (!this.up) {
                    if (this.background[0].isCollision || this.background[1].isCollision) {
                        this.down = false;
                        this.up = true;
                    }
                    if (this.background[0].isCollision || this.background[1].isCollision) {
                        this.upCollision = true;
                    }
                }
            } else if (keyCode == -2) {
                if (!this.down) {
                    if (this.background[0].isCollision || this.background[1].isCollision) {
                        this.up = false;
                        this.down = true;
                    }
                    if (this.background[0].isCollision || this.background[1].isCollision) {
                        this.downCollision = true;
                    }
                }
            } else if (keyCode == -5 && !this.startTimer && !this.isPaused) {
                this.startTimer = true;
            }
        }
        if (keyCode == -6) {
            if (this.screen == this.gameScreen) {
                if (this.isPaused) {
                    this.startTimer = true;
                    this.isPaused = false;
                    this.handledSound(2);
                } else {
                    this.startTimer = false;
                    this.isPaused = true;
                    this.handledSound(1);
                    this.repaint();
                }
                this.generateBg();
            } else if (this.screen == this.gameOverScreen) {
                this.reset();
                this.generateBg();
                this.screen = this.gameScreen;
                this.handledSound(2);
                this.reset();
            }
        } else if (keyCode == -7) {
            this.reset();
            this.md.callMainCanvas();
            this.handledSound(1);
        }
        if (keyCode == -1) {
            if (this.seLadd == 1) {
                this.seLadd = 0;
                this.advertisements.selectAdds(true, false);
            } else if (this.seLadd == 2) {
                this.advertisements.selectAdds(false, false);
                this.seLadd = 1;
            }
        } else if (keyCode == -2) {
            if (this.seLadd == 0) {
                this.seLadd = 1;
                this.advertisements.selectAdds(false, false);
            } else if (this.seLadd == 1) {
                this.advertisements.selectAdds(false, true);
                this.seLadd = 2;
            }
        }
        this.advertisements.keyPressed(keyCode);
        this.repaint();
    }

    void callGameOver() {
        if (this.playerSprite.getY() < -this.playerSprite.getHeight() || this.playerSprite.getY() > this.HH + this.playerSprite.getHeight()) {
            this.skipAction = 1;
            this.screen = this.fullAdScreen;
            this.setScore(this.score);
            this.reset();
            this.handledSound(1);
        }
    }

    private void generateBC() {
        for (int i = 0; i < 2; ++i) {
            if (this.bc[i] != null) continue;
            this.bc[i] = new BoosterCoin(this, this.WW, this.HH, this.WW + i * this.WW / 4);
        }
    }

    private void drawBoosterCoin(Graphics g) {
        for (int i = 0; i < this.bc.length; ++i) {
            if (this.bc[i] == null) continue;
            this.bc[i].doPaint(g);
            if (this.bc[i].xCord >= 0) continue;
            this.bc[i] = null;
            this.generateBC();
        }
    }

    private void drawScore(Graphics g) {
        g.drawImage(Res.scoreBg, 0, 0, 0);
        g.setColor(0);
        this.spriteC.setRefPixelPosition(0, 5);
        this.spriteC.setFrame(this.coinIndex);
        this.spriteC.paint(g);
        this.coinIndex = this.coinIndex < 9 ? ++this.coinIndex : 0;
        g.setFont(this.md.mainCanvas.f1);
        g.drawString("" + this.score, this.md.mainCanvas.f1.getHeight(), 5, 0);
    }

    private void reset() {
        this.setDATA();
        this.playerSprite.setPosition(this.playerX, this.playerY);
        this.effectSprite.setPosition(this.playerX, this.playerY);
        this.currentScore = this.score;
        this.score = 0;
        for (int i = 0; i < 2; ++i) {
            this.background[i] = null;
        }
        this.generateBg();
        this.up = false;
        this.down = true;
        this.booster = false;
        this.bgChanger = 0;
    }

    public void setScore(int score) {
        int previousScore = this.getScore();
        if (score > previousScore) {
            Configuration.Set("Score1", "" + score);
        }
    }

    public int getScore() {
        int localScore = 0;
        String l = Configuration.Get("Score1");
        if (l != null && l.length() > 0) {
            localScore = (int)Double.parseDouble(l);
        }
        return localScore;
    }

    public int getHighScore() {
        this.highScore = this.getScore();
        return this.highScore;
    }

    public void handledSound(int n) {
        int SNo = -1;
        SNo = n;
        if (this.md.mainCanvas.isSound) {
            if (SNo == 1) {
                if (this.soundHandler.animalSound != null) {
                    this.soundHandler.stopSound();
                }
                SNo = -1;
            } else if (SNo == 2) {
                if (this.soundHandler.animalSound != null) {
                    this.soundHandler.playSound(-1);
                }
                SNo = -1;
            }
        }
    }

    public void commandAction(Command c2, Displayable d2) {
        if (c2 == this.backCommand) {
            this.keyPressed(-7);
        }
    }

    public void advertisementsCallBack(int i) {
        if (this.skipAction == 1) {
            this.screen = this.gameOverScreen;
        }
        this.skipAction = -1;
    }

    public void doRepaint() {
        this.repaint();
    }
}

