/*
 * Decompiled with CFR 0.152.
 */
package ant;

import java.util.Random;
import java.util.Vector;

public class LabyrinthGenerator {
    static final int UP = 1;
    static final int DOWN = 2;
    static final int LEFT = 3;
    static final int RIGHT = 4;
    static final int DEAD = 5;
    static final int FREE = 0;
    static final int EXIT = 6;
    static final int ENTRY = 7;
    static final int WAY = 8;
    static final int FLAG = 16;
    static final int PAPA = 19;
    private int _$1412 = 0;
    int[][] table;
    int width;
    int height;
    private Random _$1417 = new Random();
    private Random _$1418 = new Random();

    public int[] getOpportunities(int x, int y) {
        int[] opsint;
        int size;
        Vector<Integer> ops = new Vector<Integer>();
        if (x > 1 && this.table[x - 2][y] == 0) {
            ops.addElement(new Integer(3));
        }
        if (x < this.width * 2 - 1 && this.table[x + 2][y] == 0) {
            ops.addElement(new Integer(4));
        }
        if (y > 1 && this.table[x][y - 2] == 0) {
            ops.addElement(new Integer(2));
        }
        if (y < this.height * 2 - 1 && this.table[x][y + 2] == 0) {
            ops.addElement(new Integer(1));
        }
        if ((size = ops.size()) == 0) {
            opsint = null;
        } else {
            opsint = new int[size];
            for (int k = 0; k < size; ++k) {
                opsint[k] = (Integer)ops.elementAt(k);
            }
        }
        return opsint;
    }

    public void generate(int x, int y) {
        int[] ops;
        while ((ops = this.getOpportunities(x, y)) != null) {
            int op = (int)Math.abs((long)this._$1417.nextInt() * (long)ops.length / (long)Integer.MAX_VALUE);
            switch (ops[op]) {
                case 4: {
                    this.table[x + 1][y] = 8;
                    this.table[x + 2][y] = 8;
                    if (this._$1412 < 4 && this._$1418.nextLong() > (long)0) {
                        this.table[x + 1][y] = 19;
                        ++this._$1412;
                    }
                    this.generate(x + 2, y);
                    break;
                }
                case 3: {
                    this.table[x - 1][y] = 8;
                    this.table[x - 2][y] = 8;
                    if (this._$1412 < 8 && this._$1418.nextLong() > (long)0) {
                        this.table[x - 1][y] = 19;
                        ++this._$1412;
                    }
                    this.generate(x - 2, y);
                    break;
                }
                case 1: {
                    this.table[x][y + 1] = 8;
                    this.table[x][y + 2] = 8;
                    if (this._$1412 < 4 && this._$1418.nextLong() > (long)0) {
                        this.table[x][y + 1] = 19;
                        ++this._$1412;
                    }
                    this.generate(x, y + 2);
                    break;
                }
                case 2: {
                    this.table[x][y - 1] = 8;
                    this.table[x][y - 2] = 8;
                    if (this._$1412 < 8 && this._$1418.nextLong() > (long)0) {
                        this.table[x][y - 1] = 19;
                        ++this._$1412;
                    }
                    this.generate(x, y - 2);
                }
            }
        }
    }

    public int[][] generateLabyrinth(int width, int height) {
        this.table = new int[width * 2 + 3][height * 2 + 3];
        this.width = width;
        this.height = height;
        this._$1417.setSeed(System.currentTimeMillis() + this._$1418.nextLong());
        for (int i = 0; i < width * 2 + 1; ++i) {
            for (int j = 0; j < height * 2 + 1; ++j) {
                this.table[i][j] = 0;
            }
        }
        this.generate(1, 1);
        boolean flag = false;
        this.table[width * 2 - 1][height * 2 - 1] = 20;
        System.gc();
        return this.table;
    }

    static {
        UP = 1;
        DOWN = 2;
        LEFT = 3;
        RIGHT = 4;
        DEAD = 5;
        FREE = 0;
        EXIT = 6;
        ENTRY = 7;
        WAY = 8;
        FLAG = 16;
        PAPA = 19;
    }
}

